/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id ObrFetcherActivator.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.fetcher.impl.obr.activator;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Constants;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.impl.obr.ObrResourceFetcherFactory;
import org.ow2.util.plan.repository.api.IRepositoryManager;

/**
 * 
 * @author Mickaël LEDUQUE
 *
 */
public class ObrFetcherActivator implements BundleActivator, ServiceListener {

    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(ObrFetcherActivator.class);

    /**
     * The bundle context.
     */
    private BundleContext bundleContext = null;

    /**
     * The fetcher factory.
     */
    private ObrResourceFetcherFactory fetcherFactory = null;

    /**
     * The fetcher factory registration reference.
     */
    private ServiceRegistration obrFetcherFactoryRegistration = null;

    /**
     * {@inheritDoc}
     */
    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.fetcherFactory = new ObrResourceFetcherFactory();
        this.fetcherFactory.setBundleContext(this.bundleContext);
        

        ServiceReference repositoryManagerRef = context.getServiceReference(
                                                IRepositoryManager.class.getName());
        if (repositoryManagerRef != null) {
            this.fetcherFactory.setRepositoryManager(
                        (IRepositoryManager)context.getService(repositoryManagerRef));
        }

        this.obrFetcherFactoryRegistration = context.registerService(
                        IResourceFetcherFactory.class.getName(),
                        this.fetcherFactory, null);

        /* registers self as service events listener */
        context.addServiceListener(this, "(" + Constants.OBJECTCLASS +
                            "=" + IRepositoryManager.class.getName() + ")");
    }

    /**
     * {@inheritDoc}
     */
    public void stop(BundleContext context) throws Exception {
        this.obrFetcherFactoryRegistration.unregister();

    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object serviceObject = this.bundleContext.getService(serviceRef);
        if (serviceObject instanceof IRepositoryManager) {
            IRepositoryManager repositoryManager = (IRepositoryManager) serviceObject;
            switch (event.getType()) {
                case ServiceEvent.REGISTERED :
                    if (this.fetcherFactory.getRepositoryManager() == null) {
                        this.fetcherFactory.setRepositoryManager(repositoryManager);
                        logger.debug("The repository manager is set to '{0}'.", repositoryManager);
                    }
                    break;
                case ServiceEvent.UNREGISTERING :
                    this.fetcherFactory.setRepositoryManager(null);
                    logger.debug("The repository manager is unset");
                    break;
                default : break;
            }
        }
        
    }

}
