/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id LocalDirectoryConfiguration.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.fetcher.impl;

import java.io.File;
import java.util.Dictionary;

import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.Constants;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;

/**
 * @author Mickaël LEDUQUE
 */
public class LocalRepositoriesBaseDirConfiguration implements ManagedService {

    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(FetcherActivator.class);

    /**
     * The local repositories base directory.
     */
    private File localRepositoriesBaseDir = null;

    /**
     * The related resource fetcher factory manager.
     */
    private IResourceFetcherFactoryManager resourceFetcherFactoryManager;

    /**
     * Creates a LocalRepositoriesBaseDirConfiguration with the given resource fetcher
     * factory manager.
     * @param manager the resource fetcher factory manager.
     */
    public LocalRepositoriesBaseDirConfiguration(IResourceFetcherFactoryManager manager) {
        this.resourceFetcherFactoryManager = manager;
    }


    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("unchecked")
    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            String path = (String) properties.get(Constants.LOCAL_REPOSITORIES_BASE_DIR);
            logger.debug("Local repositories base directory property updated: '{0}", path);
            if (path == null) {
                throw new ConfigurationException(Constants.LOCAL_REPOSITORIES_BASE_DIR, "Path to the local repositories is null.");
            }
            File localDir = new File(path);

            if (!localDir.exists()) {
                localDir.mkdirs();
            }

            this.localRepositoriesBaseDir = localDir;

            for (IResourceFetcherFactory factory : this.resourceFetcherFactoryManager) {
                factory.setLocalRepositoriesBaseDir(this.localRepositoriesBaseDir);
            }
        }
    }

}
