/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id MonitorActivator.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.monitor.activator;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.monitor.api.IResourceMonitor;
import org.ow2.util.plan.monitor.impl.ResourceMonitorImpl;

/**
 * Activator for the resource monitor bundle.
 * @author Mickaël LEDUQUE
 */
public class MonitorActivator implements BundleActivator {
    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(MonitorActivator.class);

    /**
     * Service registration for the resource monitor.
     */
    private ServiceRegistration monitorRegistration = null;

    /**
     * The resource monitor.
     */
    private IResourceMonitor resourceMonitor = null;

    /**
     * @{inheritDoc}
     */
    public void start(BundleContext bc) throws Exception {
        this.resourceMonitor = new ResourceMonitorImpl();
        this.monitorRegistration = bc.registerService(IResourceMonitor.class.getName(),
                this.resourceMonitor, null);
        logger.debug("registered a Resource Monitor : {0}", this.resourceMonitor);
    }

    /**
     * @{inheritDoc}
     */
    public void stop(BundleContext bc) throws Exception {
        this.monitorRegistration.unregister();
        logger.debug("Resource Monitor unregistered");
    }

}
