/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id RepositoryActivator.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.plan.repository.impl;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.repository.api.IRepositoryManager;

/**
 * Activator for the repository bundle.
 * @author Mickaël LEDUQUE
 *
 */
public class RepositoryActivator implements BundleActivator {
    
    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(RepositoryActivator.class);

    /**
     * The ServiceRegistration object for the registered XmlHelper object.
     */
    private ServiceRegistration repositoryManagerServiceRegistration = null;

    /**
     * {@inheritDoc}
     */
    public void start(BundleContext context) throws Exception {
        IRepositoryManager repositoryManager = new CustomRepositoryManager();
        repositoryManagerServiceRegistration = context.registerService(
                IRepositoryManager.class.getName(), repositoryManager, null);
        logger.debug("Repository Manager {0} registered", repositoryManager);
    }

    /**
     * {@inheritDoc}
     */
    public void stop(BundleContext context) throws Exception {
        repositoryManagerServiceRegistration.unregister();
        logger.debug("Repository Manager unregistered");
    }

}
