/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.osgi.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.ow2.carol.jndi.enc.java.javaURLContextFactory;
import org.ow2.carol.jndi.intercept.spi.InterceptorInitialContextFactory;
import org.ow2.carol.jndi.spi.IIOPContextWrapperFactory;
import org.ow2.carol.jndi.spi.IRMIContextWrapperFactory;
import org.ow2.carol.jndi.spi.JRMPContextWrapperFactory;
import org.ow2.carol.jndi.spi.JacORBIIOPContextWrapperFactory;
import org.ow2.carol.jndi.spi.LMIContextWrapperFactory;
import org.ow2.carol.jndi.spi.URLInitialContextFactory;

public class Activator
implements BundleActivator {
    private Set<ServiceRegistration> registrations = new HashSet<ServiceRegistration>();

    public void start(BundleContext context) throws Exception {
        this.registerInitialContextFactory(context, (InitialContextFactory)new IIOPContextWrapperFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new IRMIContextWrapperFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new JacORBIIOPContextWrapperFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new JRMPContextWrapperFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new LMIContextWrapperFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new MultiOrbInitialContextFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new InterceptorInitialContextFactory());
        this.registerInitialContextFactory(context, (InitialContextFactory)new URLInitialContextFactory());
        try {
            this.registerURLContextFactory(context, (ObjectFactory)new javaURLContextFactory(), "java");
        }
        catch (Throwable error) {
            String message = "org.ow2.carol.jndi.enc.java.javaURLContextFactory was not found, it will be ignored.";
            LogService logger = this.findLogService(context);
            if (logger != null) {
                logger.log(4, message, error);
            }
            System.err.println("[DEBUG] " + message);
        }
    }

    private LogService findLogService(BundleContext context) {
        ServiceReference ref = context.getServiceReference(LogService.class.getName());
        if (ref != null) {
            return (LogService)context.getService(ref);
        }
        return null;
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration registration : this.registrations) {
            registration.unregister();
        }
    }

    private void registerInitialContextFactory(BundleContext context, InitialContextFactory factory) {
        String[] interfaces = new String[]{InitialContextFactory.class.getName(), factory.getClass().getName()};
        this.registrations.add(context.registerService(interfaces, (Object)factory, null));
    }

    private void registerURLContextFactory(BundleContext context, ObjectFactory urlContextFactory, String scheme) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.jndi.url.scheme", scheme);
        this.registrations.add(context.registerService(ObjectFactory.class.getName(), (Object)urlContextFactory, props));
    }
}

