/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CMIMBeanConfigException.java 1176 2007-08-12 13:41:01Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.admin;

/**
 * Exception thrown if there is a failure in the JMX.
 * @author new CMI Team
 */
public class CMIMBeanConfigException extends Exception{

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -5754440414188602485L;

     /**
     * Constructs a new runtime exception with the specified detail message.
     * @param message the detail message.
     */
    public CMIMBeanConfigException(final String message) {
        super(message);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and cause.
     * @param message the detail message
     * @param cause the cause
     */
    public CMIMBeanConfigException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
