/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CentralizedConfig.java 1462 2007-10-26 13:25:11Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.config;

import java.util.Properties;

import net.jcip.annotations.Immutable;

import org.ow2.carol.cmi.admin.MBeanUtils;

/**
 * Centralizes configuration of each module.
 * @author The new CMI team
 */
@Immutable
public final class CentralizedConfig {

    /**
     * Utility class, no constructor.
     */
    private CentralizedConfig() {}

    /**
     * Initializes the CMI properties with reading the given properties.
     * @param props properties
     * @throws CMIConfigException if the configuration files are not correct
     */
    public static void setProperties(final Properties props) throws CMIConfigException {
        CMIConfig.setProperties(props);
    }

     /**
     * Initializes the CMI runtime configuration for the MBean.
     *
     * @param domainName the name of the JOnAS domain
     * @param serverName the name of the server for creating MBeans
     * @param agentId the agent identifier of the MBeanServer to retrieve
     */
    public static void setMBean(final String domainName, final String serverName, final String agentId) {
        MBeanUtils.setMBeanParameters(domainName, serverName, agentId);
    }

}
