/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ejb2_1.pool;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.pool.NamingPoolException;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.RemoteCMIReferenceableWrapper;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.PoolEntryStatistics;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBObjectFactory
implements PoolFactory<CMIReferenceable, CMIReference> {
    private static final Log LOGGER = LogFactory.getLog(EJBObjectFactory.class);
    private final ClusterViewManager clusterViewManager;

    public EJBObjectFactory(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    public CMIReferenceable create(CMIReference cmiReference) throws PoolException {
        Object ejbObject;
        Method methodCreate;
        Class<?> homeClass;
        InitialContext chosenContext;
        ServerRef serverRef = cmiReference.getServerRef();
        String protocol = serverRef.getProtocol();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.clusterViewManager.getInitialContextFactoryName(protocol));
        env.put("java.naming.provider.url", serverRef.getProviderURL());
        try {
            chosenContext = new InitialContext(env);
        }
        catch (NamingException e) {
            LOGGER.error((Object)"Cannot get a real context", new Object[]{e});
            throw new PoolException("Cannot get a real context", (Throwable)e);
        }
        if (chosenContext == null) {
            LOGGER.error((Object)"Cannot get a real context", new Object[0]);
            throw new PoolException("Cannot get a real context");
        }
        String bindName = cmiReference.getObjectName();
        try {
            homeClass = this.clusterViewManager.getInterface(bindName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot get interface for name {0}", new Object[]{bindName, e});
            throw new PoolException("Cannot get interface for name " + bindName, (Throwable)e);
        }
        EJBHome ejbHome = null;
        try {
            LOGGER.debug((Object)"Lookup {0} on {1}", new Object[]{bindName, serverRef.getProviderURL()});
            ejbHome = (EJBHome)PortableRemoteObject.narrow((Object)chosenContext.lookup(bindName), homeClass);
        }
        catch (NamingException e) {
            LOGGER.info((Object)"No ClientClusterViewProvider is bound with the name {0} at the url {1}", new Object[]{bindName, serverRef.getProviderURL(), e});
            throw new NamingPoolException("No ClientClusterViewProvider is bound with the name " + bindName + " at the url " + serverRef.getProviderURL(), e);
        }
        try {
            methodCreate = homeClass.getDeclaredMethod("create", new Class[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Cannot get method create for home class: " + homeClass.getName()), new Object[]{e});
            throw new EJBInvocationHandlerException("Cannot get method create for home class: " + homeClass.getName(), e);
        }
        try {
            ejbObject = methodCreate.invoke((Object)ejbHome, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Cannot invoke method create for ejb home: " + ejbHome), new Object[]{e});
            throw new EJBInvocationHandlerException("Cannot invoke method create for ejb home: " + ejbHome, e);
        }
        return new RemoteCMIReferenceableWrapper<EJBObject>(cmiReference, (EJBObject)ejbObject);
    }

    public boolean isMatching(CMIReferenceable object, CMIReference clue) {
        LOGGER.debug((Object)"{0} == {1} ?", new Object[]{object.getReference(), clue});
        return object.getReference().equals(clue);
    }

    public void remove(CMIReferenceable object) {
    }

    public boolean validate(CMIReferenceable object, PoolEntryStatistics stats) {
        return true;
    }
}

