/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.policy;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.lb.LoadBalanceable;
import org.ow2.carol.cmi.lb.NoLoadBalanceableException;
import org.ow2.carol.cmi.lb.decision.BasicDecisionManager;
import org.ow2.carol.cmi.lb.decision.DecisionUtil;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class RoundRobinPolicy<T extends LoadBalanceable>
implements ILBPolicy<T> {
    private static final long serialVersionUID = -4797858448720276586L;
    private static final Log LOGGER = LogFactory.getLog(RoundRobinPolicy.class);
    private static final int INITIAL_VALUE = -1;
    private int pointer = -1;
    private ILBStrategy<T> lbStrategy = null;
    private final Random rand = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List<T> cmiRefsWithStrategy;
        if (loadBalanceables == null) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        if (this.lbStrategy != null) {
            cmiRefsWithStrategy = this.lbStrategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        this.pointer = this.pointer == -1 ? this.rand.nextInt(cmiRefsWithStrategy.size()) : (this.pointer + 1) % cmiRefsWithStrategy.size();
        return (T)((LoadBalanceable)cmiRefsWithStrategy.get(this.pointer));
    }

    public BasicDecisionManager<Void> onInvokeException(Method method, Object[] parameters, T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnInvoke(thr)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    @Override
    public <ReturnType> BasicDecisionManager<ReturnType> onReturn(Method method, Object[] parameters, T loadBalanceable, ReturnType retVal) {
        LOGGER.debug((Object)"onReturn: do nothing !", new Object[0]);
        return BasicDecisionManager.doReturn(retVal);
    }

    public BasicDecisionManager<Void> onLookupException(T loadBalanceable, Throwable thr) {
        if (DecisionUtil.mustFailoverOnLookup(thr)) {
            return BasicDecisionManager.doRetry();
        }
        return BasicDecisionManager.doThrow();
    }

    @Override
    public synchronized void setStrategy(ILBStrategy<T> lbStrategy) {
        this.lbStrategy = lbStrategy;
    }

    public String toString() {
        return "RoundRobinPolicy - pointer: " + this.pointer + " - LB strategy: " + this.lbStrategy;
    }
}

