/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.lb.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LoadFactor
implements ILBStrategy<CMIReference> {
    private static final long serialVersionUID = -7859116721872110483L;
    private static final Log LOGGER = LogFactory.getLog(LoadFactor.class);
    private final ClusterViewManager clusterViewManager;

    public LoadFactor(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
    }

    @Override
    public List<CMIReference> choose(List<CMIReference> cmiRefs) {
        ArrayList<CMIReference> orderedCMIRefs = new ArrayList<CMIReference>(cmiRefs);
        Collections.sort(orderedCMIRefs, new LoadFactorComparator());
        return orderedCMIRefs;
    }

    public String toString() {
        return "LoadFactor";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadFactorComparator
    implements Comparator<CMIReference> {
        private LoadFactorComparator() {
        }

        @Override
        public int compare(CMIReference cmiRef1, CMIReference cmiRef2) {
            int factor2;
            int factor1;
            try {
                factor1 = LoadFactor.this.clusterViewManager.getLoadFactor(cmiRef1.getServerRef());
                factor2 = LoadFactor.this.clusterViewManager.getLoadFactor(cmiRef2.getServerRef());
            }
            catch (ServerNotFoundException e) {
                throw new RuntimeException(e);
            }
            return new Integer(factor1).compareTo(factor2);
        }
    }
}

