/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.admin;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.admin.CMIAdminMBean;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManagerException;
import org.ow2.carol.cmi.lb.PropertyConfigurationException;
import org.ow2.carol.cmi.lb.data.LBPropertyData;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.lb.util.LBPolicyFactory;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CMIAdmin
implements CMIAdminMBean {
    private static final Log LOGGER = LogFactory.getLog(CMIAdmin.class);
    private final ClusterViewManager clusterViewManager;
    private final ObjectName objectName;
    private static CMIAdmin cmiAdmin;

    private CMIAdmin(ClusterViewManager clusterViewManager) {
        this.clusterViewManager = clusterViewManager;
        this.objectName = null;
    }

    private CMIAdmin(ClusterViewManager clusterViewManager, ObjectName objectName) {
        this.clusterViewManager = clusterViewManager;
        this.objectName = objectName;
    }

    public static synchronized CMIAdmin getCMIAdmin(ObjectName objectName, ClusterViewManager clusterViewManager) {
        if (cmiAdmin == null) {
            cmiAdmin = new CMIAdmin(clusterViewManager, objectName);
        }
        return cmiAdmin;
    }

    public static synchronized CMIAdmin getCMIAdmin() {
        if (cmiAdmin == null) {
            ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
            cmiAdmin = new CMIAdmin(clusterViewManager);
        }
        return cmiAdmin;
    }

    public static synchronized void setCMIAdmin(CMIAdmin cmiAdmin) {
        if (cmiAdmin == null | CMIAdmin.cmiAdmin == null) {
            CMIAdmin.cmiAdmin = cmiAdmin;
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public JMXServiceURL getJMXServiceURL(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        JMXServiceURL jmxServiceURL = ((ServerClusterViewManager)this.clusterViewManager).getJMXServiceURL(protocolName);
        if (jmxServiceURL == null) {
            throw new IllegalArgumentException("Unknown protocol: " + protocolName);
        }
        return jmxServiceURL;
    }

    @Override
    public Set<String> getProtocols() {
        return this.clusterViewManager.getProtocols();
    }

    @Override
    public String getItfName(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            return ((ServerClusterViewManager)this.clusterViewManager).getItfName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n " + e.getMessage());
        }
    }

    @Override
    public String getBusinessName(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            return ((ServerClusterViewManager)this.clusterViewManager).getBusinessName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public boolean isReplicated(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.isReplicated(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Set<String> getServerRefsForProtocol(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        Set<ServerRef> serverRefs;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            serverRefs = ((ServerClusterViewManager)this.clusterViewManager).getServerRefs(protocolName);
        }
        catch (ServerClusterViewManagerException e) {
            throw new IllegalArgumentException("Protocol not found: " + protocolName + "\n" + e.getMessage());
        }
        HashSet<String> result = new HashSet<String>();
        for (ServerRef serverRef : serverRefs) {
            result.add(serverRef.getProviderURL());
        }
        return result;
    }

    @Override
    public Set<String> getServerObjectsForProtocol(String serverUrl, String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        Set<String> objectRefs;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            objectRefs = ((ServerClusterViewManager)this.clusterViewManager).getServerObjectForProtocol(serverUrl, protocolName);
        }
        catch (ServerClusterViewManagerException e) {
            throw new IllegalArgumentException("Unable to get Objects for server " + serverUrl + " on " + protocolName + " protocol \n" + e.getMessage());
        }
        return objectRefs;
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clusterViewManager.getObjectNames();
    }

    @Override
    public String getRefOnLocalRegistry(String protocolName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ServerRef serverRef = ((ServerClusterViewManager)this.clusterViewManager).getRefOnLocalRegistry(protocolName);
        if (serverRef == null) {
            throw new IllegalArgumentException(serverRef + " doesn't exist");
        }
        return serverRef.getProviderURL();
    }

    @Override
    public String getLBPolicyClassName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getLBPolicyClassName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setLBPolicyClassName(String objectName, String lbPolicyClassName) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setLBPolicyClassName(objectName, lbPolicyClassName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public String getLBStrategyClassName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getLBStrategyClassName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setLBStrategyClassName(String objectName, String lbStrategyClassName) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setLBStrategyClassName(objectName, lbStrategyClassName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Set<String> getPropertiesNamesForLBPolicy(String objectName) throws IllegalArgumentException {
        Class<? extends ILBPolicy> lbPolicyClass;
        try {
            lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        HashSet<String> propertiesNames = new HashSet<String>();
        try {
            Map<String, LBPropertyData> properties = LBPolicyFactory.getPropertyData(lbPolicyClass);
            for (String propertyName : properties.keySet()) {
                if (List.class.equals((Object)LBPolicyFactory.getPropertyRawType(lbPolicyClass, propertyName))) continue;
                propertiesNames.add(propertyName);
            }
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Cannot get properties for class {0}", new Object[]{lbPolicyClass.getName(), e});
            throw new RuntimeException("Cannot get properties for class " + lbPolicyClass.getName() + "\n" + e.getMessage());
        }
        return propertiesNames;
    }

    @Override
    public Set<String> getListPropertiesNamesForLBPolicy(String objectName) throws IllegalArgumentException {
        Class<? extends ILBPolicy> lbPolicyClass;
        try {
            lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        HashSet<String> propertiesNames = new HashSet<String>();
        try {
            Map<String, LBPropertyData> properties = LBPolicyFactory.getPropertyData(lbPolicyClass);
            for (String propertyName : properties.keySet()) {
                if (!List.class.equals((Object)LBPolicyFactory.getPropertyRawType(lbPolicyClass, propertyName))) continue;
                propertiesNames.add(propertyName);
            }
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Cannot get properties for class {0}", new Object[]{lbPolicyClass.getName(), e});
            throw new RuntimeException("Cannot get properties for class " + lbPolicyClass.getName() + "\n" + e.getMessage());
        }
        return propertiesNames;
    }

    @Override
    public String getPropertyForLBPolicy(String objectName, String propertyName) throws IllegalArgumentException {
        ILBPolicy<CMIReference> lbPolicy;
        try {
            lbPolicy = this.clusterViewManager.getLBPolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        Class<?> lbPolicyClass = lbPolicy.getClass();
        try {
            Type propertyType = LBPolicyFactory.getPropertyRawType(lbPolicyClass, propertyName);
            if (List.class.equals((Object)propertyType)) {
                LOGGER.error((Object)"The value of property {0} is a list", new Object[]{objectName});
                throw new IllegalArgumentException("The value of property " + objectName + " is a list");
            }
            return LBPolicyFactory.getProperty(lbPolicy, propertyName).toString();
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Cannot get properties for class {0}", new Object[]{lbPolicyClass.getName(), e});
            throw new RuntimeException("Cannot get properties for class " + lbPolicyClass.getName() + "\n" + e.getMessage());
        }
    }

    @Override
    public List<String> getListPropertyForLBPolicy(String objectName, String propertyName) throws IllegalArgumentException {
        ILBPolicy<CMIReference> lbPolicy;
        try {
            lbPolicy = this.clusterViewManager.getLBPolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        Class<?> lbPolicyClass = lbPolicy.getClass();
        try {
            Type propertyType = LBPolicyFactory.getPropertyRawType(lbPolicyClass, propertyName);
            if (!List.class.equals((Object)propertyType)) {
                LOGGER.error((Object)"The value of property {0} is not a list", new Object[]{objectName});
                throw new IllegalArgumentException("The value of property " + objectName + " is not a list");
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Object obj : (List)LBPolicyFactory.getProperty(lbPolicy, propertyName)) {
                result.add(obj.toString());
            }
            return result;
        }
        catch (PropertyConfigurationException e) {
            LOGGER.error((Object)"Cannot get properties for class {0}", new Object[]{lbPolicyClass.getName(), e});
            throw new RuntimeException("Cannot get properties for class " + lbPolicyClass.getName() + "\n" + e.getMessage());
        }
    }

    @Override
    public void setPropertyForLBPolicy(String objectName, String propertyName, String propertyValue) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends ILBPolicy> lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertyForLBPolicy(objectName, propertyName, LBPolicyFactory.convertString(lbPolicyClass, propertyName, propertyValue));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The property " + propertyName + " cannot be applied", e);
        }
    }

    @Override
    public void setListPropertyForLBPolicy(String objectName, String propertyName, List<String> propertyValue) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends ILBPolicy> lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertyForLBPolicy(objectName, propertyName, LBPolicyFactory.convertStrings(lbPolicyClass, propertyName, propertyValue));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The property " + propertyName + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    @Override
    public void setPropertiesForLBPolicy(String objectName, Map<String, Object> properties) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            Class<? extends ILBPolicy> lbPolicyClass = this.clusterViewManager.getLBPolicyClass(objectName);
            ((ServerClusterViewManager)this.clusterViewManager).setPropertiesForLBPolicy(objectName, this.convertProperties(lbPolicyClass, properties));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The properties " + properties + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    @Override
    public void setAlgorithmForLBPolicy(String objectName, String lbPolicyClassName, String lbStrategyClassName, Map<String, Object> properties) throws IllegalArgumentException, UnsupportedOperationException, ClassNotFoundException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Class<?> lbPolicyClass = Class.forName(lbPolicyClassName);
        Class<?>[] interfaces = lbPolicyClass.getInterfaces();
        if (!Arrays.asList(interfaces).contains(ILBPolicy.class)) {
            throw new IllegalArgumentException(lbPolicyClassName + " doesn't implement the interface " + ILBPolicy.class.getName());
        }
        Class<?> lbStrategyClass = Class.forName(lbStrategyClassName);
        interfaces = lbStrategyClass.getInterfaces();
        if (!Arrays.asList(interfaces).contains(ILBStrategy.class)) {
            throw new IllegalArgumentException(lbStrategyClassName + " doesn't implement the interface " + ILBStrategy.class.getName());
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setAlgorithmForLBPolicy(objectName, lbPolicyClassName, lbStrategyClassName, this.convertProperties(lbPolicyClass, properties));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        catch (PropertyConfigurationException e) {
            throw new IllegalArgumentException("The properties " + properties + " cannot be applied" + "\n" + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> convertProperties(Class<? extends ILBPolicy> lbPolicyClass, Map<String, Object> properties) throws ObjectNotFoundException, PropertyConfigurationException {
        HashMap<String, Object> castedProps = new HashMap<String, Object>();
        for (String propertyName : properties.keySet()) {
            Type propertyType = LBPolicyFactory.getPropertyType(lbPolicyClass, propertyName);
            List<?> value = properties.get(propertyName);
            if (propertyType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)propertyType;
                if (!parameterizedType.getRawType().equals(List.class)) throw new PropertyConfigurationException("Support only list as parameterized type");
                if (parameterizedType.getActualTypeArguments().equals(String.class)) {
                    value = LBPolicyFactory.convertStrings(lbPolicyClass, propertyName, (List)properties.get(propertyName));
                }
            } else if (propertyType.equals(String.class)) {
                value = LBPolicyFactory.convertString(lbPolicyClass, propertyName, (String)properties.get(propertyName));
            }
            castedProps.put(propertyName, value);
        }
        return castedProps;
    }

    @Override
    public List<String> getServerRefs(String objectName, String protocolName) throws IllegalArgumentException {
        List<CMIReference> cmiReferences;
        try {
            cmiReferences = this.clusterViewManager.getCMIReferences(objectName, protocolName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        ArrayList<String> stringOfCMIRefs = new ArrayList<String>(cmiReferences.size());
        for (CMIReference cmiReference : cmiReferences) {
            stringOfCMIRefs.add(cmiReference.getServerRef().getProviderURL());
        }
        return stringOfCMIRefs;
    }

    @Override
    public List<String> getServerRefs(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        List<CMIReference> cmiReferences;
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            cmiReferences = ((ServerClusterViewManager)this.clusterViewManager).getCMIReferences(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
        ArrayList<String> stringOfCMIRefs = new ArrayList<String>(cmiReferences.size());
        for (CMIReference cmiReference : cmiReferences) {
            stringOfCMIRefs.add(cmiReference.getServerRef().getProviderURL());
        }
        return stringOfCMIRefs;
    }

    @Override
    public Set<String> getClusterNames() throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Set<String> clusterNames = ((ServerClusterViewManager)this.clusterViewManager).getClusterNames();
        return clusterNames;
    }

    @Override
    public Set<String> getObjectNames(String clusterName) throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        Set<String> objectNames = ((ServerClusterViewManager)this.clusterViewManager).getObjectNames(clusterName);
        return objectNames;
    }

    @Override
    public Integer getDelayToRefresh() {
        return this.clusterViewManager.getDelayToRefresh();
    }

    @Override
    public void setDelayToRefresh(Integer delay) throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).setDelayToRefresh(delay);
    }

    @Override
    public String getClusterName(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getClusterName(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Integer getMaxPoolSize(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getMaxPoolSize(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Integer getMinPoolSize(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.getMinPoolSize(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws IllegalArgumentException {
        try {
            return this.clusterViewManager.isPoolToEmpty(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public boolean isServerBlackListed(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).isServerBlackListed(new ServerRef(serverName));
    }

    @Override
    public void addPooltoEmpty(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).addPoolToEmpty(objectName);
    }

    @Override
    public void addServerToBlackList(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).addServerToBlackList(new ServerRef(serverName));
    }

    @Override
    public void removePoolToEmpty(String objectName) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).removePoolToEmpty(objectName);
    }

    @Override
    public void removeServerFromBlackList(String serverName) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).removeServerFromBlackList(new ServerRef(serverName));
    }

    @Override
    public void setMaxPoolSize(String objectName, Integer maxSize) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setMaxPoolSize(objectName, maxSize);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public void setMinPoolSize(String objectName, Integer minSize) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        try {
            ((ServerClusterViewManager)this.clusterViewManager).setMinPoolSize(objectName, minSize);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Object not found: {0}", new Object[]{objectName, e});
            throw new IllegalArgumentException("Object not found: " + objectName + "\n" + e.getMessage());
        }
    }

    @Override
    public Integer getLoadFactor(String serverRef) throws IllegalArgumentException, MalformedURLException, UnknownHostException {
        try {
            return this.clusterViewManager.getLoadFactor(new ServerRef(serverRef));
        }
        catch (ServerNotFoundException e) {
            LOGGER.error((Object)"Server not found: {0}", new Object[]{serverRef, e});
            throw new IllegalArgumentException("Server not found: " + serverRef + "\n" + e.getMessage());
        }
    }

    @Override
    public void setLoadFactor(String serverRef, String loadFactor) throws UnsupportedOperationException, MalformedURLException, UnknownHostException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        ((ServerClusterViewManager)this.clusterViewManager).setLoadFactor(new ServerRef(serverRef), new Integer(loadFactor));
    }

    @Override
    public Integer getNbClientsConnectedToProvider() {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).getNbClientsConnectedToProvider();
    }

    public Boolean receiveFile(Byte[] fileBuff, String fileName, String attributeToSet) throws IllegalArgumentException, UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        if ("lbPolicy".equals(attributeToSet) || "lbStrategy".equals(attributeToSet)) {
            // empty if block
        }
        return true;
    }

    @Override
    public Map<String, Set<String>> retrieveAvailableLBPoliciesAndStrategies() throws UnsupportedOperationException {
        if (!(this.clusterViewManager instanceof ServerClusterViewManager)) {
            LOGGER.error((Object)"Clients cannot call this method", new Object[0]);
            throw new UnsupportedOperationException("Clients cannot call this method");
        }
        return ((ServerClusterViewManager)this.clusterViewManager).getAvailableLBPoliciesAndStrategies();
    }
}

