/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: LBProperties.java 1342 2007-10-23 18:39:24Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates some properties to apply at a policy of load-balancing.
 * A property can have a simple value represented by a {@link String}
 * or an array of simple values represented by an array of {@link String}.
 * A simple value has to have one of the following types:
 * primitive types, {@link java.net.URL}, {@link java.io.File}, {@link Class}.
 * @author The new CMI team
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface LBProperties {

    /**
     * @return the simple properties of this LB policy
     */
    LBProperty[] value() default {};

    /**
    * @return the array properties of this LB policy
    */
   LBArrayProperty[] values() default {};

}
