/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: LBStrategy.java 1201 2007-08-20 11:39:57Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.ow2.carol.cmi.lb.strategy.ILBStrategy;


/**
 * Indicates which strategy will be used with the instances of the annotated class.
 * If the class is not also also annotated by {@link Cluster}, using this annotation has no effect.
 * @author The new CMI team
 * @see Cluster
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface LBStrategy {

    /**
     * @return the type of strategy for load-balancing
     */
    @SuppressWarnings("unchecked")
    Class<? extends ILBStrategy> value();
}
