/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CMIReferenceable.java 1299 2007-10-08 16:16:16Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.reference;

/**
 * Interface of an object that is managed by a {@link org.ow2.util.pool.Pool}.
 * This interface is dynamically added (by the method
 * {@link org.ow2.carol.cmi.pool.StubOrProxyFactory#create(CMIReference)})
 * at a stub or proxy to enable management of stubs and proxies.
 * @author The new CMI team
 * @see org.ow2.util.pool.Pool
 * @see  org.ow2.carol.cmi.pool.StubOrProxyFactory#create(CMIReference)
 */
public interface CMIReferenceable<T> {

    /**
     * @return a CMIReference
     */
    CMIReference getReference();

    /**
     * @return the object that is referenced by the CMIReference
     */
    T getReferencedObject();

}
