/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: ClientClusterViewManager.java 1596 2008-01-27 17:50:35Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.controller.client;

import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;

/**
 * Interface for a manager of the cluster view at client-side.
 * @author The new CMI team
 */
public interface ClientClusterViewManager extends ClusterViewManager {

    /**
     * Returns the bytecode of the class with the given binary name.
     * @param binaryName a binary name of a class
     * @return the bytecode of the class with the given binary name
     * @throws ClientClusterViewManagerException if the bytecode cannot obtained
     */
    byte[] getBytecode(String binaryName) throws ClientClusterViewManagerException;

    /**
     * Updates informations about clustering for every watched objects.
     * @throws ClientClusterViewManagerException if the update failed
     */
    void updateClusterView() throws ClientClusterViewManagerException;

    /**
     * Updates informations about clustering for the object with the given name.
     * @param objectName a name of object
     * @throws ObjectNotFoundException if no object is bound with the given name
     * @throws ClientClusterViewManagerException if the update failed
     */
    void pullAndupdateObjectInfos(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException;

    /**
     * @return true if the cluster view provider is available
     */
    boolean isClusterViewProviderAvailable();

}
