/**
 * Copyright (C) 2007 - Bull S.A.S.
 *
 * CMI : Cluster Method Invocation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DecisionManager.java 1334 2007-10-19 14:44:36Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.cmi.lb.decision;


/**
 * Encapsulates a decision and an eventually returned value.
 * @param <ReturnType> the type of the returned value (can be {@link Void})
 * @author The new CMI team
 */
public interface DecisionManager<ReturnType> {

    /**
     * Decisions.
     */
    public enum Decision{RETURN, RETRY, THROW}


    /**
     * @return the decision
     */
    Decision getDecision();

    /**
     * @return the returned value
     */
    ReturnType getRetVal();
}
