/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007,2008 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:Strategy.java 949 2007-06-02 17:24:33Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.lb.strategy;

import java.util.List;

import org.ow2.carol.cmi.lb.LoadBalanceable;

/**
 * Interface of the load-balancing strategies.
 * A strategy allows to modify a list of load-balanceables before applying a policy to elect only one load-balanceable.
 * @param <T> The type of object that was load-balanced
 * @author The new CMI team
 */
public interface ILBStrategy<T extends LoadBalanceable> {

    /**
     * Returns a new list of load-balanceables by modifying the given list.
     * @param loadBalanceables a list of load-balanceables
     * @return a new list of load-balanceables by modifying the given list
     */
    List<T> choose(List<T> loadBalanceables);

}
