/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: ServerNotFoundException.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.reference;

/**
 * Indicate that a server cannot be found.
 * @author Loris Bouzonnet
 */
public class ServerNotFoundException extends Exception {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 370328153778947617L;

    /**
     * The reference on the server that cannot be found.
     */
    private final ServerRef serverRef;

    public ServerNotFoundException(final String message, final ServerRef serverRef) {
        super(message);
        this.serverRef = serverRef;
    }

    public ServerNotFoundException(final String message, final Throwable cause, final ServerRef serverRef) {
        super(message, cause);
        this.serverRef = serverRef;
    }

    /**
     * @return the reference on the server that cannot be found
     */
    public ServerRef getServerRef() {
        return serverRef;
    }

}
