/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: SmartConnector.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.smart.api;

import java.util.List;

/**
 * @author The new CMI team
 *
 */
public interface SmartConnector {

    /**
     * Gets the list of Provider URL.
     * @param protocolName the given protocol name.
     * @return providers of the cluster view for the given protocol
     * @throws Exception
     */
    List<String> getProviderURLs(final String protocolName) throws Exception;

    /**
     * Gets the Factory name.
     * @param protocolName the protocol name.
     * @return the factory name
     */
    String getInitialContextFactoryName(final String protocolName);

}
