/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007,2008 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: ArrayProperty.java 1649 2008-02-28 17:36:13Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Defines an array property for policy of load-balancing.
 * To be used by the annotation {@link Properties}.
 * @author The new CMI team
 * @see Properties
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface ArrayProperty {

    /**
     * Name of property.
     */
    String name();

    /**
     * Array of string values.
     */
    String[] values();

}
