/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007,2008 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:Cluster.java 949 2007-06-02 17:24:33Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.ow2.util.pool.annotation.Pool;


/**
 * Indicates that instances of the annotated class are intended to be replicated in a cluster.
 * To specify the way to access to these instances,
 * the annotations {@link Policy}, {@link Strategy} and {@link Properties} must be used.
 * @author The new CMI team
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Cluster {

    /**
     * Name of cluster.
     */
    String name() default "defaultCluster";

    /**
     * Filename for a CMI descriptor in order to override (or complete) the description given by annotations.
     */
    String descriptor() default "policy.xml";

    /**
     * Pool attributes.
     */
    Pool pool() default @Pool;

}
