/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: SessionId.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ha;

import java.io.Serializable;
import java.util.UUID;

/**
 * Identify a session.
 * @author The new CMI team
 */
public class SessionId implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 6618569352062958003L;

    /**
     * UUID of a manager.
     */
    private final UUID clientId;

    /**
     * Number of session.
     */
    private final long sessionNb;

    public SessionId(final UUID clientId, final long sessionNb) {
        this.clientId = clientId;
        this.sessionNb = sessionNb;
    }

    /**
     * @return the clientId
     */
    public UUID getClientId() {
        return clientId;
    }

    /**
     * @return the localSessionId
     */
    public long getLocalSessionId() {
        return sessionNb;
    }

    @Override
    public int hashCode() {
        return clientId.hashCode() + Long.valueOf(sessionNb).hashCode();
    }

    @Override
    public String toString() {
        return "SessionId[clientId:"+clientId.toString()
                +", sessionNb:"+sessionNb+"]";
    }

    @Override
    public boolean equals(final Object object) {
        if(object == null || !(object instanceof SessionId)) {
            return false;
        }
        SessionId sessionId = (SessionId) object;
        return clientId.equals(sessionId.clientId) && sessionNb == sessionId.sessionNb;
    }
}
