/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:NoServerException.java 949 2007-06-02 17:24:33Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.lb;

import java.rmi.RemoteException;

/**
* Thrown when no more remote object is available in the cluster for a
* remote procedure call.
*
* @author The new CMI team
*/

public class NoLoadBalanceableException extends RemoteException {

    /**
     * UID.
     */
    private static final long serialVersionUID = 4155853772786296842L;

    /**
     * Creates an instance without argument.
     *
     */
    public NoLoadBalanceableException() {
        super();
    }
    /**
     * Creates an instance with a message.
     * @param message message
     */
    public NoLoadBalanceableException(final String message) {
        super(message);
    }

    /**
     * Creates an instance with a message and an exception.
     * @param msg message
     * @param ex exception
     */
    public NoLoadBalanceableException(final String msg, final Throwable ex) {
        super(msg, ex);
    }
}
