/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CMIProxyHandle.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.carol.cmi.reference;

import java.io.Serializable;
import java.rmi.RemoteException;

import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

import org.ow2.carol.cmi.rpc.CMIProxy;

/**
 * Handle an instance of {@link CMIProxy}.
 * The instances of this class can be replicated with Tomcat HA.
 * @author Loris Bouzonnet
 */
public interface CMIProxyHandle extends Serializable, HttpSessionBindingListener {

    /**
     * @return the cmi proxy
     * @throws RemoteException if the unserialization fails
     */
    CMIProxy getCMIProxy() throws RemoteException;

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpSessionBindingListener#valueBound(javax.servlet.http.HttpSessionBindingEvent)
     */
    void valueBound(final HttpSessionBindingEvent arg0);

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpSessionBindingListener#valueUnbound(javax.servlet.http.HttpSessionBindingEvent)
     */
    void valueUnbound(final HttpSessionBindingEvent arg0);

    /**
     * Update the HTTP session in which is bound the associated Handle.
     * @return the new reference used by the HTTP session
     */
    CMIProxyHandle updateHttpSession();

    byte[] getSerializedCMIInvocationHandler();

    String getInterfaceName();

    String getObjectName();

}
