/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.controller.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.admin.CMIMBeanConfigException;
import org.ow2.carol.cmi.admin.MBeanUtils;
import org.ow2.carol.cmi.config.CMIConfig;
import org.ow2.carol.cmi.controller.client.CMIClientClassLoader;
import org.ow2.carol.cmi.controller.client.ClientClusterViewCache;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManager;
import org.ow2.carol.cmi.controller.client.ClientClusterViewManagerException;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.CMIThreadFactory;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.carol.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.carol.cmi.info.CMIInfoExtractor;
import org.ow2.carol.cmi.info.CMIInfoExtractorException;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.cmi.lb.data.LBPolicyData;
import org.ow2.carol.cmi.lb.policy.ILBPolicy;
import org.ow2.carol.cmi.lb.strategy.ILBStrategy;
import org.ow2.carol.cmi.pool.StubOrProxyFactory;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.reference.ServerRef;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.carol.cmi.rpc.POJOInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ClientClusterViewManagerImpl
extends AbsClusterViewManager
implements ClientClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(ClientClusterViewManagerImpl.class);
    private final String initialContextFactoryName;
    private final String protocol;
    private final Thread clientClusterViewUpdater;
    private static volatile ClientClusterViewProvider clientClusterViewProvider;
    private volatile boolean clusterViewProviderAvailable = false;

    private ClientClusterViewManagerImpl(String initialContextFactoryName, String protocol) {
        this.initialContextFactoryName = initialContextFactoryName;
        this.protocol = protocol;
        CMIThreadFactory cmiThreadFactory = this.getCmiThreadFactory();
        this.clientClusterViewUpdater = cmiThreadFactory.newThread(new Runnable(){

            public void run() {
                int refreshTime;
                try {
                    clientClusterViewProvider.registerClient(ClientClusterViewManagerImpl.this.getUUID());
                    refreshTime = ClientClusterViewManagerImpl.this.getDelayToRefresh();
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Thread {0}> Cannot register the client", new Object[]{Thread.currentThread().getName(), e});
                    refreshTime = 10000;
                }
                while (true) {
                    LOGGER.debug((Object)"Thread {0} is sleeping for {1} millis...", new Object[]{Thread.currentThread().getName(), refreshTime});
                    try {
                        Thread.sleep(refreshTime);
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug((Object)"Thread client interrupted", new Object[]{e});
                    }
                    LOGGER.debug((Object)"Thread {0}> Updating the client cluster view...", new Object[]{Thread.currentThread().getName()});
                    try {
                        ClientClusterViewManagerImpl.this.updateClusterView();
                        ClientClusterViewManagerImpl.this.clusterViewProviderAvailable = true;
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Thread {0}> Cannot update the cluster view", new Object[]{Thread.currentThread().getName(), e});
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public static synchronized ClientClusterViewManager getClientClusterViewManager(String initialContextFactoryName, String protocol, List<ServerRef> serverRefs) throws ClientClusterViewManagerException {
        ClusterViewManager clusterViewManager = AbsClusterViewManager.getClusterViewManager();
        if (clusterViewManager == null) {
            LOGGER.debug((Object)"Constructing a ClientClusterviewManager...", new Object[0]);
            ClientClusterViewManagerImpl clientClusterViewManager = new ClientClusterViewManagerImpl(initialContextFactoryName, protocol);
            clientClusterViewManager.initDataOfProvider(serverRefs);
            clientClusterViewManager.initDataOfDummyRegistry();
            clientClusterViewManager.clientClusterViewUpdater.start();
            if (CMIConfig.isEmbedded()) {
                try {
                    MBeanUtils.initCMIMBean();
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.error((Object)"Cannot initializes CMIMBean", new Object[]{e});
                }
                try {
                    MBeanUtils.registerCMIMBean(clientClusterViewManager);
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.error((Object)"Cannot registers CMIMBean", new Object[]{e});
                }
            }
            clusterViewManager = clientClusterViewManager;
            AbsClusterViewManager.setClusterViewManager(clusterViewManager);
            LOGGER.info((Object)"The client-side manager was successfully started", new Object[0]);
        } else if (!(clusterViewManager instanceof ClientClusterViewManager)) {
            LOGGER.error((Object)"An instance of the manager that is not a ClientClusterViewManager already exists in the JVM", new Object[0]);
            throw new ClientClusterViewManagerException("An instance of the manager that is not a ClientClusterViewManager already exists in the JVM");
        }
        return (ClientClusterViewManager)clusterViewManager;
    }

    private void initDataOfProvider(List<ServerRef> serverRefs) throws ClientClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        LOGGER.debug((Object)"**** Begin of initialization of the connection at provider...", new Object[0]);
        String providerName = CMIConfig.getBindNameForProvider();
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        for (ServerRef serverRef : serverRefs) {
            cmiReferences.add(new CMIReference(serverRef, providerName));
        }
        ClientClusterViewCache.setCMIReferences(providerName, cmiReferences);
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot extract the informations about provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot extract the informations about provider", e);
        }
        ClientClusterViewCache.setItfName(providerName, ClientClusterViewProvider.class);
        ClientClusterViewCache.setReplicated(providerName, false);
        Class<? extends ILBPolicy> lbPolicyClass = clusteredObjectInfo.getPolicyType();
        Class<? extends ILBStrategy> lbStrategyClass = clusteredObjectInfo.getStrategyType();
        LBPolicyData lbPolicyDataForProvider = new LBPolicyData(lbPolicyClass.getName(), lbStrategyClass.getName(), clusteredObjectInfo.getProperties());
        ClientClusterViewCache.setLBPolicyData(providerName, lbPolicyDataForProvider);
        ClientClusterViewCache.setLBPolicyClass(providerName, lbPolicyClass);
        ClientClusterViewCache.setLBStrategyClass(providerName, lbStrategyClass);
        this.initLocalData(providerName);
        try {
            this.updateLBPolicy(providerName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot initialize informations of the provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot initialize informations of the provider", e);
        }
        try {
            this.setPool(providerName, (Pool<CMIReferenceable, CMIReference>)new JPool((PoolFactory)new StubOrProxyFactory(this)));
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot get set the pool for the provider with name {0}", new Object[]{providerName, e});
            throw new ClientClusterViewManagerException("Cannot set the pool for the provider with name " + providerName, e);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        POJOInvocationHandler invocationHandler = new POJOInvocationHandler(classLoader, this, providerName, this.protocol, ClientClusterViewProvider.class);
        clientClusterViewProvider = (ClientClusterViewProvider)Proxy.newProxyInstance(classLoader, new Class[]{ClientClusterViewProvider.class, CMIProxy.class}, (InvocationHandler)invocationHandler);
        try {
            this.updateObject(providerName);
            this.clusterViewProviderAvailable = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Provider not found", new Object[]{e});
        }
        LOGGER.debug((Object)"**** End of initialization of the connection at provider.", new Object[0]);
    }

    private void initDataOfDummyRegistry() {
        String dummyName = CMIConfig.getBindNameForDummyRegistry();
        this.initLocalData(dummyName);
        try {
            this.updateObject(dummyName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Dummy registry not found", new Object[]{e});
        }
    }

    @Override
    public synchronized void addObjectToWatch(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        if (!this.isLocalDataInitialized(objectName)) {
            boolean hasState;
            String itfName;
            LOGGER.debug((Object)"Initializing local data for object with name {0}", new Object[]{objectName});
            try {
                itfName = clientClusterViewProvider.getItfName(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot pull the name of interface for object with name {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot get pull the name of interface for object with name " + objectName, e);
            }
            ClassLoader currentCLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> itfClass = Class.forName(itfName, true, currentCLoader);
                ClientClusterViewCache.setItfName(objectName, itfClass);
            }
            catch (ClassNotFoundException e) {
                throw new ClientClusterViewManagerException("Cannot load the interface for name " + itfName, e);
            }
            if (Arrays.asList(this.getInterface(objectName).getInterfaces()).contains(EJBHome.class)) {
                String businessName;
                try {
                    businessName = clientClusterViewProvider.getBusinessName(objectName);
                }
                catch (RemoteException e) {
                    LOGGER.error((Object)"Cannot pull the name of business interface for object with name {0}", new Object[]{objectName, e});
                    throw new ClientClusterViewManagerException("Cannot get pull the name of business interface for object with name " + objectName, e);
                }
                try {
                    Class<?> businessClass = Class.forName(businessName, true, currentCLoader);
                    ClientClusterViewCache.setBusinessName(objectName, businessClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ClientClusterViewManagerException("Cannot load the business interface for name " + businessName, e);
                }
            }
            try {
                hasState = clientClusterViewProvider.isReplicated(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot know if the object with name {0} has a state", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot know if the object with name " + objectName + " has a state", e);
            }
            ClientClusterViewCache.setReplicated(objectName, hasState);
            this.initLocalData(objectName);
        }
    }

    @Override
    public Class<?> getInterface(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<?> itfName = ClientClusterViewCache.getItfName(objectName);
        if (itfName == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return itfName;
    }

    @Override
    public Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<? extends EJBObject> businessName = ClientClusterViewCache.getBusinessName(objectName);
        if (businessName == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return businessName;
    }

    @Override
    public Class<? extends ILBPolicy> getLBPolicyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<? extends ILBPolicy> lbPolicy = ClientClusterViewCache.getLBPolicyClass(objectName);
        if (lbPolicy == null) {
            try {
                lbPolicy = this.pullLBPolicyClass(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot set the class of policy for {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot set the class of policy for " + objectName, e);
            }
            ClientClusterViewCache.setLBPolicyClass(objectName, lbPolicy);
        }
        return lbPolicy;
    }

    @Override
    public Class<? extends ILBStrategy> getLBStrategyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        Class<? extends ILBStrategy> lbStrategy = ClientClusterViewCache.getLBStrategyClass(objectName);
        if (lbStrategy == null) {
            try {
                lbStrategy = this.pullLBStrategyClass(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot set the class of strategy for {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot set the class of strategy for " + objectName, e);
            }
            ClientClusterViewCache.setLBStrategyClass(objectName, lbStrategy);
        }
        return lbStrategy;
    }

    @Override
    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        List<CMIReference> cmiReferences = ClientClusterViewCache.getCMIReferences(objectName);
        if (cmiReferences == null) {
            LOGGER.debug((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return cmiReferences;
    }

    @Override
    public long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        LBPolicyData lbPolicyData = ClientClusterViewCache.getLBPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getDateOfProperties();
    }

    private Class<? extends ILBPolicy> pullLBPolicyClass(String objectName) throws ObjectNotFoundException, RemoteException {
        Class<? extends ILBPolicy> lbPolicyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            lbPolicyClass = clientClusterViewProvider.getLBPolicyClass(objectName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot download the LB policy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the LB policy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return lbPolicyClass;
    }

    private Class<? extends ILBStrategy> pullLBStrategyClass(String objectName) throws RemoteException, ObjectNotFoundException {
        Class<? extends ILBStrategy> lbStrategyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            lbStrategyClass = clientClusterViewProvider.getLBStrategyClass(objectName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Cannot download the LB policy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the LB strategy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return lbStrategyClass;
    }

    @Override
    public boolean isPoolToEmpty(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.isPoolToEmpty(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot pull the flag to reset or no the pool for object {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the flag to reset or no the pool for object " + objectName, e);
        }
    }

    @Override
    public Map<String, Object> getPropertiesForLBPolicy(String objectName) throws ObjectNotFoundException {
        LBPolicyData lbPolicyData = ClientClusterViewCache.getLBPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getProperties();
    }

    @Override
    public Object getPropertyForLBPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        LBPolicyData lbPolicyData = ClientClusterViewCache.getLBPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getProperties().get(propertyName);
    }

    @Override
    public String getInitialContextFactoryName(String protocolName) {
        return this.initialContextFactoryName;
    }

    @Override
    public Set<String> getProtocols() {
        return Collections.singleton(this.protocol);
    }

    @Override
    public byte[] getBytecode(String binaryName) throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getBytecode(binaryName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot get bytecode for {0}", new Object[]{binaryName, e});
            throw new ClientClusterViewManagerException("Cannot get bytecode for " + binaryName, e);
        }
    }

    @Override
    public boolean isClustered(String objectName) throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.isClustered(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Connection has failed", new Object[]{e});
            throw new ClientClusterViewManagerException("Connection has failed", e);
        }
    }

    @Override
    public int getDelayToRefresh() throws ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getDelayToRefresh();
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get delay to refresh", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot get delay to refresh", e);
        }
    }

    @Override
    public String getLBStrategyClassName(String objectName) throws ObjectNotFoundException {
        LBPolicyData lbPolicyData = ClientClusterViewCache.getLBPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getStrategyType();
    }

    @Override
    public String getLBPolicyClassName(String objectName) throws ObjectNotFoundException {
        LBPolicyData lbPolicyData = ClientClusterViewCache.getLBPolicyData(objectName);
        if (lbPolicyData == null) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
        return lbPolicyData.getPolicyType();
    }

    @Override
    public String getClusterName(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        try {
            return clientClusterViewProvider.getClusterName(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get name of cluster for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot get name of cluster for object with name " + objectName, e);
        }
    }

    @Override
    public void updateObject(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        LOGGER.debug((Object)"Updating infos for: {0} - thread is {1}", new Object[]{objectName, Thread.currentThread().getName()});
        try {
            this.pullAndUpdateLBPolicy(objectName);
            this.pullAndUpdateCMIReferences(objectName);
            this.pullAndUpdatePoolSize(objectName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot pull the informations for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the informations for object with name " + objectName, e);
        }
    }

    @Override
    public void updateClusterView() throws ClientClusterViewManagerException {
        for (String objectName : this.getNamesOfInitializedObjects()) {
            try {
                this.updateObject(objectName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.fatal((Object)"The object with name {0} is unknown", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("The object with name " + objectName + " is unknown", e);
            }
        }
        this.pullAndUpdateLoadFactors();
    }

    private void pullAndUpdateLBPolicy(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException, RemoteException {
        String lastLBPolicyName = clientClusterViewProvider.getLBPolicyClassName(objectName);
        if (lastLBPolicyName == null) {
            LOGGER.error((Object)"The new name of LB policy is null.", new Object[0]);
            throw new ClientClusterViewManagerException("The new name of LB policy is null.");
        }
        LOGGER.debug((Object)"New LB policy name: {0}", new Object[]{lastLBPolicyName});
        String lastLBStrategyName = clientClusterViewProvider.getLBStrategyClassName(objectName);
        if (lastLBStrategyName == null) {
            LOGGER.error((Object)"The new name of LB strategy is null.", new Object[0]);
            throw new ClientClusterViewManagerException("The new name of LB strategy is null.");
        }
        LOGGER.debug((Object)"New LB strategy name: {0}", new Object[]{lastLBStrategyName});
        long dateOfLastProps = clientClusterViewProvider.getDateOfProperties(objectName);
        LOGGER.debug((Object)"New date of properties: {0}", new Object[]{dateOfLastProps});
        if (ClientClusterViewCache.getLBPolicyData(objectName) != null) {
            String lbPolicyName = this.getLBPolicyClassName(objectName);
            LOGGER.debug((Object)"Old LB policy name: {0}", new Object[]{lbPolicyName});
            long dateOfProps = this.getDateOfProperties(objectName);
            LOGGER.debug((Object)"Old date of properties: {0}", new Object[]{dateOfProps});
            String lbStrategyName = this.getLBStrategyClassName(objectName);
            LOGGER.debug((Object)"Old LB strategy name: {0}", new Object[]{lbStrategyName});
            if (lbPolicyName.equals(lastLBPolicyName) && dateOfProps == dateOfLastProps && lbStrategyName.equals(lastLBStrategyName)) {
                return;
            }
        }
        Map<Object, Object> lastProperties = dateOfLastProps == 0L ? new HashMap() : clientClusterViewProvider.getPropertiesForLBPolicy(objectName);
        ClientClusterViewCache.setLBPolicyData(objectName, new LBPolicyData(lastLBPolicyName, lastLBStrategyName, lastProperties, dateOfLastProps));
        try {
            this.updateLBPolicy(objectName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot get LB policy for object {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot get LB policy for object " + objectName, e);
        }
    }

    private void pullAndUpdateCMIReferences(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException, RemoteException {
        List<CMIReference> cmiReferences = clientClusterViewProvider.getCMIReferences(objectName, this.protocol);
        if (cmiReferences == null) {
            LOGGER.error((Object)"The new node list for {0} is null", new Object[]{objectName});
            throw new ClientClusterViewManagerException("The new node list for " + objectName + " is null");
        }
        ClientClusterViewCache.setCMIReferences(objectName, cmiReferences);
    }

    private void pullAndUpdatePoolSize(String objectName) {
    }

    private void pullAndUpdateLoadFactors() {
        for (ServerRef address : ClientClusterViewCache.getAddressesOfServer()) {
            try {
                int loadFactor = clientClusterViewProvider.getLoadFactor(address);
                ClientClusterViewCache.setLoadFactor(address, loadFactor);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Cannot pull the load factor for server with address {0}", new Object[]{address, e});
                throw new ClientClusterViewManagerException("Cannot pull the load factor for server with address " + address, e);
            }
        }
    }

    @Override
    public int getMaxPoolSize(String objectName) throws ObjectNotFoundException {
        try {
            return clientClusterViewProvider.getMaxPoolSize(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot pull the maximal size of pool for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the maximal size of pool for object with name " + objectName, e);
        }
    }

    @Override
    public int getMinPoolSize(String objectName) throws ObjectNotFoundException {
        try {
            return clientClusterViewProvider.getMinPoolSize(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot pull the minimal size of pool for object with name {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot pull the minimal size of pool for object with name " + objectName, e);
        }
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) {
        return ClientClusterViewCache.getLoadFactor(serverRef);
    }

    @Override
    public boolean isReplicated(String objectName) throws ObjectNotFoundException {
        return ClientClusterViewCache.isReplicated(objectName);
    }

    @Override
    public Set<String> getObjectNames() {
        return ClientClusterViewCache.getObjectNames();
    }

    @Override
    public boolean isClusterViewProviderAvailable() {
        return this.clusterViewProviderAvailable;
    }
}

