/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ha;

import java.io.Serializable;
import java.util.Vector;
import org.ow2.carol.cmi.ha.BeanInfo;
import org.ow2.carol.cmi.ha.RequestId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HaMessageData
implements Serializable {
    private static final long serialVersionUID = -1656256040790087473L;
    private HaMessageKind type;
    private RequestId requestId;
    private Object response;
    private Vector<BeanInfo> beans;
    private boolean readOnly;
    private Vector<HaMessageData> otherMessages;

    public static HaMessageData newCommittingMessage(RequestId requestId, Object response, Vector<BeanInfo> beans, boolean readOnly, Vector<HaMessageData> otherMessages) {
        return new HaMessageData(HaMessageKind.COMMITTING_MESSAGE, requestId, response, beans, readOnly, otherMessages);
    }

    public static HaMessageData newCommitMessage(RequestId requestId) {
        return new HaMessageData(HaMessageKind.COMMIT_MESSAGE, requestId, null, null, false, null);
    }

    public static HaMessageData newAbortMessage(RequestId requestId, Object response) {
        return new HaMessageData(HaMessageKind.ABORT_MESSAGE, requestId, response, null, false, null);
    }

    private HaMessageData(HaMessageKind type, RequestId requestId, Object response, Vector<BeanInfo> beans, boolean readOnly, Vector<HaMessageData> otherMessages) {
        this.type = type;
        this.requestId = requestId;
        this.response = response;
        this.beans = beans;
        this.readOnly = readOnly;
        this.otherMessages = otherMessages;
    }

    public Vector<BeanInfo> getBeans() {
        return this.beans;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Vector<HaMessageData> getOtherMessages() {
        return this.otherMessages;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Object getResponse() {
        return this.response;
    }

    public HaMessageKind getType() {
        return this.type;
    }

    public String toString() {
        String ret = "\nRequest id: " + this.requestId + "\n";
        ret = ret + "\ttype: " + (Object)((Object)this.type) + "\n";
        if (this.beans != null) {
            ret = ret + "\tBean changes:\n";
            for (BeanInfo bi : this.beans) {
                ret = ret + "\t\t" + bi.toString() + "\n";
            }
        }
        if (this.response != null) {
            ret = ret + "\tResponse: " + this.response + "\n";
        }
        ret = ret + "\treadOnly: " + this.readOnly;
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HaMessageKind {
        COMMITTING_MESSAGE,
        COMMIT_MESSAGE,
        ABORT_MESSAGE;

    }
}

