/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: UtilConfig.java 1181 2007-08-16 08:21:09Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

import net.jcip.annotations.Immutable;

/**
 * Common utilities for CMI.
 * @author The new CMI team
 */
@Immutable
public final class UtilConfig {

    /**
     * Private default constructor.
     */
    private UtilConfig() {}

    /**
     * Gets a properties object based on given URL.
     * @param url URL from where build properties object
     * @return properties object with data from the given URL
     * @throws CMIConfigException if we cannot load properties
     */
    public static Properties getPropertiesFromURL(final URL url) throws CMIConfigException {
        if (url == null) {
            return new Properties();
        }

        // Get inputStream + invalid cache
        InputStream is = null;
        try {
            URLConnection urlConnect = null;
            urlConnect = url.openConnection();
            // disable cache
            urlConnect.setDefaultUseCaches(false);

            is = urlConnect.getInputStream();
        } catch (IOException ioe) {
            throw new CMIConfigException("Invalid URL '" + url + "' : " + ioe.getMessage(), ioe);
        }

        // Check inpustream
        if (is == null) {
            throw new CMIConfigException("No inputstream for URL '" + url + "'.");
        }

        // load properties from URL
        Properties p = new Properties();
        try {
            p.load(is);
        } catch (IOException ioe) {
            throw new CMIConfigException("Could not load input stream of  URL '" + url + "' : " + ioe.getMessage());
        }

        // close inputstream
        try {
            is.close();
        } catch (IOException ioe) {
            throw new CMIConfigException("Cannot close inputStream", ioe);
        }

        return p;
    }

}
