/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.config.CMIConfigException;
import org.ow2.carol.cmi.config.CMIProperty;
import org.ow2.carol.cmi.config.UtilConfig;
import org.ow2.carol.cmi.controller.server.ServerClusterViewManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CMIConfig {
    private static final Log LOGGER = LogFactory.getLog(CMIConfig.class);
    public static final String CMI_PROPERTIES = "cmi.properties";
    private static final int DEFAULT_REFRESH_TIME = 30000;
    private static final String DEFAULT_MANAGER = "org.ow2.carol.cmi.controller.server.impl.jgroups.JGroupsClusterViewManager";
    private static final String DEFAULT_PROVIDER_BIND_NAME = "client_provider";
    private static final String DEFAULT_DUMMY_REGISTRY_BIND_NAME = "dummy_registry";
    public static final int DEFAULT_LOAD_FACTOR = 100;
    private static boolean configured = false;
    private static final Properties UNRECOGNIZED_PROPS = new Properties();
    private static int refreshTime = 30000;
    private static Class<? extends ServerClusterViewManager> serverClusterViewManagerClass = null;
    private static String mbeanDomainName = "CMI";
    private static String cmiAdminMBeanName = "CMIAdmin";
    private static List<String> protocolsOfTheConnectors = new ArrayList<String>();
    private static boolean providerBound = true;
    private static boolean registryBound = true;
    private static String bindNameForProvider = "client_provider";
    private static final String bindNameForDummyRegistry = "dummy_registry";
    private static int loadFactor = 100;
    private static volatile boolean embedded = false;

    private CMIConfig() {
    }

    public static synchronized void init() throws CMIConfigException {
        CMIConfig.setProperties(Thread.currentThread().getContextClassLoader().getResource(CMI_PROPERTIES));
    }

    public static synchronized void setProperties(Properties props) throws CMIConfigException {
        if (configured) {
            return;
        }
        LOGGER.debug((Object)"Starting the configuration of CMI...", new Object[0]);
        LOGGER.debug((Object)"CMI props: {0}", new Object[]{props.toString()});
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            String s = props.getProperty(k);
            if (k.equals(CMIProperty.REFRESH_TIME.getPropertyName())) {
                refreshTime = new Integer(s);
                continue;
            }
            if (k.equals(CMIProperty.REPLICATION_MANAGER_CLASS.getPropertyName())) {
                if (s == null) {
                    s = DEFAULT_MANAGER;
                }
                try {
                    serverClusterViewManagerClass = Class.forName(s);
                    continue;
                }
                catch (ClassNotFoundException e1) {
                    LOGGER.error((Object)"Cannot load the specified class of manager: {0}.", new Object[]{s});
                    throw new CMIConfigException("Cannot load the specified class of manager: " + s, e1);
                }
            }
            if (k.equals(CMIProperty.MBEAN_DOMAIN_NAME.getPropertyName())) {
                mbeanDomainName = s;
                continue;
            }
            if (k.equals(CMIProperty.CMIADMIN_MBEAN_NAME.getPropertyName())) {
                cmiAdminMBeanName = s;
                continue;
            }
            if (k.equals(CMIProperty.PROTOCOLS_OF_THE_CONNECTORS.getPropertyName())) {
                String[] protocolsArray = s.split(",");
                protocolsOfTheConnectors = Arrays.asList(protocolsArray);
                continue;
            }
            if (k.equals(CMIProperty.PROVIDER_BOUND.getPropertyName())) {
                providerBound = new Boolean(s);
                continue;
            }
            if (k.equals(CMIProperty.REGISTRY_BOUND.getPropertyName())) {
                registryBound = new Boolean(s);
                continue;
            }
            if (k.equals(CMIProperty.PROVIDER_BIND_NAME.getPropertyName())) {
                bindNameForProvider = s;
                continue;
            }
            if (k.equals(CMIProperty.LOAD_FACTOR.getPropertyName())) {
                loadFactor = new Integer(s);
                continue;
            }
            UNRECOGNIZED_PROPS.setProperty(k, s);
        }
        configured = true;
        LOGGER.debug((Object)"Configuration of CMI is done.", new Object[0]);
    }

    public static synchronized void setProperties(URL url) throws CMIConfigException {
        if (url == null) {
            LOGGER.error((Object)"The given URL is null", new Object[0]);
            throw new CMIConfigException("The given URL is null");
        }
        Properties props = UtilConfig.getPropertiesFromURL(url);
        CMIConfig.setProperties(props);
    }

    public static int getRefreshTime() {
        return refreshTime;
    }

    public static Class<? extends ServerClusterViewManager> getServerClusterViewManagerClass() {
        return serverClusterViewManagerClass;
    }

    public static String getCMIProperty(String key) {
        return UNRECOGNIZED_PROPS.getProperty(key);
    }

    public static String getMBeanDomainName() {
        return mbeanDomainName;
    }

    public static String getCMIAdminMBeanName() {
        return cmiAdminMBeanName;
    }

    public static boolean isConnectorEnabled(String protocol) {
        return protocolsOfTheConnectors.contains(protocol);
    }

    public static boolean isProviderBound() {
        return providerBound;
    }

    public static String getBindNameForProvider() {
        return bindNameForProvider;
    }

    public static String getBindNameForDummyRegistry() {
        return "dummy_registry";
    }

    public static int getLoadFactor() {
        return loadFactor;
    }

    public static boolean isConfigured() {
        return configured;
    }

    public static boolean isRegistryBound() {
        return registryBound;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static void setEmbedded() {
        embedded = true;
    }
}

