/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.config;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ProviderURLsParser {
    private static final int URL_HOSTPORT_INDEX = 2;

    private ProviderURLsParser() {
    }

    private static String parseScheme(String inputscheme) throws MalformedURLException {
        if (inputscheme.length() == 0) {
            throw new MalformedURLException("Scheme cannot be empty");
        }
        if (inputscheme.length() > 1 && inputscheme.endsWith(":")) {
            return inputscheme.substring(0, inputscheme.length() - 1);
        }
        throw new MalformedURLException("badly formed scheme");
    }

    private static List<String> parseName(String scheme, String inputurl) throws MalformedURLException {
        String inputhostport = "";
        int n = inputurl.indexOf("/", 2);
        if (n != -1 || inputurl.length() <= 2) {
            throw new MalformedURLException("The syntax for URL is: <scheme>://<host>:<port>(,<host>:<port>)*");
        }
        inputhostport = inputurl.substring(2);
        return ProviderURLsParser.parseHostsPorts(scheme, inputhostport);
    }

    private static List<String> parseHostsPorts(String scheme, String inputhostsports) throws MalformedURLException {
        int end;
        int start = 0;
        ArrayList<String> providerURLs = new ArrayList<String>();
        do {
            if ((end = inputhostsports.indexOf(44, start)) < 0) {
                providerURLs.add(scheme + "://" + inputhostsports.substring(start));
                continue;
            }
            providerURLs.add(scheme + "://" + inputhostsports.substring(start, end));
        } while ((start = end + 1) > 0);
        return providerURLs;
    }

    public static List<String> parse(String input) throws MalformedURLException {
        if (input == null || input.length() == 0) {
            throw new MalformedURLException("null or empty registry URL");
        }
        if (input.indexOf("//") == -1) {
            throw new MalformedURLException("badly formed registry URL " + input);
        }
        try {
            String scheme = ProviderURLsParser.parseScheme(input.substring(0, input.indexOf("//")));
            return ProviderURLsParser.parseName(scheme, input.substring(input.indexOf("//")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MalformedURLException("badly formed registry URL " + input);
        }
    }
}

