/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CMIProperty.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.config;

/**
 * Properties to configure CMI.
 * @author Loris Bouzonnet
 */
public enum CMIProperty {

    /**
     * Property name for specifying if the replication is enabled.
     */
    REPLICATION_ENABLED("cmi.server.start.replication"),

    /**
     * Property name for defining the duration between each refresh of the client view.
     */
    REFRESH_TIME("cmi.client.refresh.time"),

    /**
     * Property name for specifying the ServerClusterViewManager.
     */
    REPLICATION_MANAGER_CLASS("cmi.server.impl.class"),

    /**
     * Property name for specifying the name of domain for MBeans.
     */
    MBEAN_DOMAIN_NAME("cmi.server.admin.domain"),

    /**
     * Property name for specifying the name of the CMIAdmin MBean.
     */
    CMIADMIN_MBEAN_NAME("cmi.server.admin.mbean"),

    /**
     * Property name for declaring the protocols that must have a RMI connector.
     */
    PROTOCOLS_OF_THE_CONNECTORS("cmi.server.admin.connector.protocol"),

    /**
     * Property name to indicate if a provider (of the cluster view) should be bound.
     */
    PROVIDER_BOUND("cmi.server.provider.bind"),

    /**
     * Property name to indicate if the local registry of this server can be accessed to lookup unclustered objects.
     */
    REGISTRY_BOUND("cmi.server.registry.bind"),

    /**
     * Property name to declare name of the ClientClusterViewProvider that is used to bind it.
     */
    PROVIDER_BIND_NAME("cmi.server.provider.bind.name"),

    /**
     * Property name to declare name of the dummy context that is used to bind it.
     */
    DUMMY_CONTEXT_BIND_NAME("cmi.context.jndi.bind.name"),

    /**
     * Property name to declare a load factor for the server.
     */
    LOAD_FACTOR("cmi.server.load"),

    /**
     * Property name to declare a list of provider URLs to access to a provider of the cluster view.
     * This property must be defined in the case of servers using a cmi client (ie having a client-side manager).
     */
    CLUSTER_VIEW_PROVIDER_URLS("cmi.server.provider.urls");

    /**
     * A name of property.
     */
    private final String propertyName;

    /**
     * @param propertyName a name of property
     */
    CMIProperty(final String propertyName) {
        this.propertyName = propertyName;
    }

    /**
     * @return the name of property
     */
    @Override
    public String toString() {
        return propertyName;
    }

    /**
     * @return the name of property
     */
    public String getPropertyName() {
        return propertyName;
    }
}
