/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CMIHandle.java 1289 2007-09-30 18:53:41Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.spec;

import java.rmi.RemoteException;

import javax.ejb.EJBObject;
import javax.ejb.Handle;

public class CMIHandle implements Handle {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 6590714152068350344L;

    private final EJBObject ejbObjectProxy;

    public CMIHandle(final EJBObject ejbObjectProxy) {
        this.ejbObjectProxy = ejbObjectProxy;
    }

    public EJBObject getEJBObject() throws RemoteException {
        return ejbObjectProxy;
    }

}
