/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: JMetaData.java 1289 2007-09-30 18:53:41Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.spec;

import java.io.Serializable;

import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;

public class JMetaData implements EJBMetaData, Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 1008245053213849356L;

    /**
     * EJB Home
     */
    private EJBHome home;

    /**
     * EJB Home class
     */
    private Class homeClass;

    /**
     * EJB Remote class
     */
    private Class remoteClass;

    /**
     * Primary Key Home class
     */
    private Class primaryKeyClass;

    /**
     * True if is a Session Bean
     */
    private boolean isSession;

    /**
     * True if is a Stateless Session Bean
     */
    private boolean isStatelessSession;

    /**
     * Constructor
     * @param home The EJBHome
     * @param homeClass EJB Home class
     * @param remoteClass EJB Remote class
     * @param isSession true if is a Session Bean
     * @param isStatelessSession true if is a StatelessSessionBean
     * @param primaryKeyClass primary key class
     */
    public JMetaData(EJBHome home, Class homeClass, Class remoteClass, boolean isSession, boolean isStatelessSession, Class primaryKeyClass) {
        this.home = home;
        this.homeClass = homeClass;
        this.remoteClass = remoteClass;
        this.isSession = isSession;
        this.isStatelessSession = isStatelessSession;
        this.primaryKeyClass = primaryKeyClass;
    }

    // -----------------------------------------------------------------------
    // EJBMetaData implementation
    // -----------------------------------------------------------------------

    /**
     * @return the home interface of the enterprise Bean.
     */
    public EJBHome getEJBHome() {
        return home;
    }

    /**
     * @return the Class object for the enterprise Bean's home interface.
     */
    public Class getHomeInterfaceClass() {
        return homeClass;
    }

    /**
     * @return the Class object for the enterprise Bean's primary key class.
     */
    public Class getPrimaryKeyClass() {
        if (isSession) {
            throw new EJBException("getPrimaryKeyClass() not allowed for session");
        }
        return primaryKeyClass;
    }

    /**
     * @return the Class object for the enterprise Bean's remote interface.
     */
    public Class getRemoteInterfaceClass() {
        return remoteClass;
    }

    /**
     * @return True if the enterprise Bean's type is "session".
     */
    public boolean isSession() {
        return isSession;
    }

    /**
     * @return True if the type of the enterprise Bean is stateless session.
     */
    public boolean isStatelessSession() {
        return isStatelessSession;
    }

}
