/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CreateMethodWrapper.java 1333 2007-10-17 20:32:51Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ha.rpc;

import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * Wrap a method 'create<METHOD>' and its arguments.
 * @author The new CMI team
 */
public final class CreateMethodWrapper {

    private final Method method;

    private final Object[] args;

    public CreateMethodWrapper(final Method method, final Object[] args) {
        this.method = method;
        this.args = args;
    }

    public Method getMethod() {
        return method;
    }

    public Object[] getArgs() {
        return args;
    }

    @Override
    public String toString() {
        return "CreateMethodWrapper[Method:"+method+",Args:"
                +Arrays.toString(args)+"]";
    }

}
