/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ejb2_1.rpc;

import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.spec.CMIHandle;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class EJBObjectInvocationHandler
extends CMIInvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(EJBObjectInvocationHandler.class);
    private final ClassLoader classLoader;
    private final Class<? extends EJBHome> homeClass;
    private final Class<? extends EJBObject> remoteClass;
    private final EJBHome ejbHomeProxy;

    public EJBObjectInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass, Class<? extends EJBObject> remoteClass, EJBHome ejbHomeProxy) {
        super(clusterViewManager, objectName, protocolName, false);
        this.classLoader = classLoader;
        this.homeClass = homeClass;
        this.remoteClass = remoteClass;
        this.ejbHomeProxy = ejbHomeProxy;
    }

    protected String proxyToString(Object proxy) {
        return "EJBObjectProxy[" + super.proxyToString(proxy) + ", homeClass:" + this.homeClass.getName() + ", remoteClass:" + this.remoteClass.getName() + ", ejbHomeProxy:" + this.ejbHomeProxy + "]";
    }

    protected Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws EJBInvocationHandlerException, Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.equals("getEJBHome")) {
                EJBHome eJBHome = this.ejbHomeProxy;
                return eJBHome;
            }
            if (methodName.equals("getHandle")) {
                CMIHandle cMIHandle = new CMIHandle((EJBObject)proxy);
                return cMIHandle;
            }
            if (methodName.equals("isIdentical")) {
                EJBObject ejbObject = (EJBObject)args[0];
                Boolean bl = this.homeClass.equals(ejbObject.getEJBHome().getEJBMetaData().getHomeInterfaceClass());
                return bl;
            }
            if (methodName.equals("remove")) {
                Object ejbObject = null;
                return ejbObject;
            }
            Object ejbObject = super.invokeRemoteMethod(proxy, method, args);
            return ejbObject;
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Error when invoking {0}", new Object[]{method, e});
            throw new EJBInvocationHandlerException("Error when invoking " + method, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

