/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ha.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.AbsClusterViewManager;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.spec.CMIHomeHandle;
import org.ow2.carol.cmi.ejb2_1.spec.JMetaData;
import org.ow2.carol.cmi.ha.rpc.CreateMethodWrapper;
import org.ow2.carol.cmi.ha.rpc.HAEJBInvocationHandlerException;
import org.ow2.carol.cmi.ha.rpc.HAEJBObjectInvocationHandler;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.CMIReferenceableWrapper;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class HAEJBHomeInvocationHandler
extends CMIInvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(HAEJBHomeInvocationHandler.class);
    private final ClassLoader classLoader;
    private final Class<? extends EJBHome> homeClass;
    private final Class<? extends EJBObject> remoteClass;
    private static final String CREATE_METHOD_PREFIX = "create";
    private static final String FIND_METHOD_PREFIX = "find";
    private EJBMetaData ejbMetaData = null;

    public HAEJBHomeInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass) {
        super(clusterViewManager, objectName, protocolName, true);
        this.classLoader = classLoader;
        this.homeClass = homeClass;
        try {
            this.remoteClass = clusterViewManager.getRemoteClass(objectName);
        }
        catch (ObjectNotFoundException e) {
            throw new HAEJBInvocationHandlerException("Cannot get the remote class for " + objectName, e);
        }
    }

    protected String proxyToString(Object proxy) {
        return "HAEJBHomeProxy[" + super.proxyToString(proxy) + ", homeClass:" + this.homeClass.getName() + ", remoteClass:" + this.remoteClass.getName() + ", ejbMetada:" + this.ejbMetaData + "]";
    }

    protected Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws HAEJBInvocationHandlerException, Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.startsWith(CREATE_METHOD_PREFIX) || methodName.startsWith(FIND_METHOD_PREFIX)) {
                Object cmiProxy;
                EJBObject ejbObject = (EJBObject)super.invokeRemoteMethod(proxy, method, args);
                CMIReferenceableWrapper remoteStubWrapped = new CMIReferenceableWrapper(super.getCurrentRef().getReference(), (Object)ejbObject);
                super.setCurrentRef(null);
                HAEJBObjectInvocationHandler ejbObjectInvocationHandler = new HAEJBObjectInvocationHandler(this.classLoader, this.clusterViewManager, this.objectName, this.protocolName, this.homeClass, this.remoteClass, (EJBHome)proxy, AbsClusterViewManager.getClusterViewManager().getSessionId(), new CreateMethodWrapper(method, args), (CMIReferenceable<EJBObject>)remoteStubWrapped);
                Object object = cmiProxy = Proxy.newProxyInstance(this.classLoader, new Class[]{this.remoteClass, CMIProxy.class}, (InvocationHandler)((Object)ejbObjectInvocationHandler));
                return object;
            }
            if (methodName.equals("getEJBMetaData")) {
                EJBMetaData ejbMetaDataRaw;
                if (this.ejbMetaData == null) {
                    ejbMetaDataRaw = (EJBMetaData)super.invokeRemoteMethod(proxy, method, args);
                    this.ejbMetaData = new JMetaData((EJBHome)proxy, this.homeClass, this.remoteClass, ejbMetaDataRaw.isSession(), ejbMetaDataRaw.isStatelessSession(), ejbMetaDataRaw.getPrimaryKeyClass());
                }
                ejbMetaDataRaw = this.ejbMetaData;
                return ejbMetaDataRaw;
            }
            if (methodName.equals("getHomeHandle")) {
                CMIHomeHandle ejbMetaDataRaw = new CMIHomeHandle((EJBHome)proxy);
                return ejbMetaDataRaw;
            }
            if (methodName.equals("remove")) {
                ((Handle)args[0]).getEJBObject().remove();
                Object ejbMetaDataRaw = null;
                return ejbMetaDataRaw;
            }
            try {
                throw new NoSuchMethodException(method.toString());
            }
            catch (Exception e) {
                if (e instanceof CreateException || e instanceof FinderException) {
                    throw e;
                }
                LOGGER.error((Object)"Error when invoking {0}", new Object[]{method, e});
                throw new EJBInvocationHandlerException("Error when invoking " + method, e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

