/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ha.rpc;

import java.lang.reflect.Method;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.spec.CMIHandle;
import org.ow2.carol.cmi.ha.RequestId;
import org.ow2.carol.cmi.ha.SessionId;
import org.ow2.carol.cmi.ha.interceptor.HACurrent;
import org.ow2.carol.cmi.ha.rpc.CreateMethodWrapper;
import org.ow2.carol.cmi.ha.rpc.HAEJBInvocationHandlerException;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.CMIReferenceableWrapper;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.carol.cmi.rpc.CMIInvocationHandlerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAEJBObjectInvocationHandler
extends CMIInvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(HAEJBObjectInvocationHandler.class);
    private final ClassLoader classLoader;
    private final Class<? extends EJBHome> homeClass;
    private final Class<? extends EJBObject> remoteClass;
    private final EJBHome ejbHomeProxy;
    private final SessionId sessionId;
    private int requestNb = 0;
    private final CreateMethodWrapper createMethodWrapper;
    private CMIReferenceable<EJBObject> wrappedRemoteStub;
    private boolean onFailover = false;

    public HAEJBObjectInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass, Class<? extends EJBObject> remoteClass, EJBHome ejbHomeProxy, SessionId sessionId, CreateMethodWrapper createMethodWrapper, CMIReferenceable<EJBObject> wrappedRemoteStub) {
        super(clusterViewManager, objectName, protocolName, true);
        this.classLoader = classLoader;
        this.homeClass = homeClass;
        this.remoteClass = remoteClass;
        this.ejbHomeProxy = ejbHomeProxy;
        this.sessionId = sessionId;
        this.createMethodWrapper = createMethodWrapper;
        this.wrappedRemoteStub = wrappedRemoteStub;
    }

    protected String proxyToString(Object proxy) {
        return "HAEJBObjectProxy[" + super.proxyToString(proxy) + ", homeClass:" + this.homeClass.getName() + ", remoteClass:" + this.remoteClass.getName() + ", ejbHomeProxy:" + this.ejbHomeProxy + ", sessionId:" + this.sessionId + ", createMethodWrapper:" + this.createMethodWrapper + ", wrappedRemoteStub:" + this.wrappedRemoteStub + ", onFailover:" + this.onFailover + "]";
    }

    protected Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws HAEJBInvocationHandlerException, Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.equals("getEJBHome")) {
                EJBHome eJBHome = this.ejbHomeProxy;
                return eJBHome;
            }
            if (methodName.equals("getHandle")) {
                CMIHandle cMIHandle = new CMIHandle((EJBObject)proxy);
                return cMIHandle;
            }
            if (methodName.equals("isIdentical")) {
                EJBObject ejbObject = (EJBObject)args[0];
                Boolean bl = this.homeClass.equals(ejbObject.getEJBHome().getEJBMetaData().getHomeInterfaceClass());
                return bl;
            }
            RequestId requestId = new RequestId(this.sessionId, this.requestNb);
            HACurrent.getHACurrent().putNextReq(requestId);
            super.setCurrentRef(this.wrappedRemoteStub);
            Object result = super.invokeRemoteMethod(proxy, method, args);
            ++this.requestNb;
            if (this.onFailover) {
                this.onFailover = false;
                HACurrent.getHACurrent().setOnFailover(false);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Error when invoking {0}", new Object[]{method, e});
            throw new EJBInvocationHandlerException("Error when invoking " + method, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void onExceptionHook() throws CMIInvocationHandlerException, Throwable {
        EJBObject ejbObject;
        try {
            ejbObject = (EJBObject)super.invokeRemoteMethod((Object)this.ejbHomeProxy, this.createMethodWrapper.getMethod(), this.createMethodWrapper.getArgs());
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Failover: Error when invoking {0}", new Object[]{this.createMethodWrapper.getMethod(), e});
            throw new EJBInvocationHandlerException("Failover: Error when invoking " + this.createMethodWrapper.getMethod(), e);
        }
        this.wrappedRemoteStub = new CMIReferenceableWrapper(super.getCurrentRef().getReference(), (Object)ejbObject);
        super.setCurrentRef(this.wrappedRemoteStub);
        this.onFailover = true;
        HACurrent.getHACurrent().setOnFailover(true);
    }
}

