/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: EJBHomeFactory.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.pool;

import javax.ejb.EJBHome;

import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.pool.StubOrProxyFactory;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.RemoteCMIReferenceableWrapper;

/**
 * Provide a specialization of the factory of {@link CMIReferenceable} for {@link EJBHome}.
 * @author Loris Bouzonnet
 */
public class EJBHomeFactory extends StubOrProxyFactory {

    public EJBHomeFactory(final ClusterViewManager clusterViewManager) {
        super(clusterViewManager);
    }

    @Override
    protected CMIReferenceable<EJBHome> getCMIReferenceable(final CMIReference cmiRef, final Object stubOrProxy) {
        return new RemoteCMIReferenceableWrapper<EJBHome>(cmiRef, (EJBHome) stubOrProxy);
    }

}
