/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: CreateMethodWrapper.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.rpc.ha;

import java.io.Serializable;
import java.util.Arrays;

/**
 * Wrap a method 'create<METHOD>' and its arguments.
 * @author The new CMI team
 */
public final class CreateMethodWrapper implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 876410471923405619L;

    private final String methodName;

    private final String[] argTypenames;

    private final Object[] args;

    public CreateMethodWrapper(final String methodName, final String[] argTypenames, final Object... args) {
        this.methodName = methodName;
        this.argTypenames = argTypenames;
        this.args = args;
    }

    public String getMethodName() {
        return methodName;
    }

    public String[] getArgTypenames() {
        return argTypenames;
    }

    public Object[] getArgs() {
        return args;
    }

    @Override
    public String toString() {
        return "CreateMethodWrapper[Method:" + methodName + ",Args:"
                + Arrays.toString(args) + "]";
    }

}
