/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: EJBHomeHandle.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.spec;

import java.rmi.RemoteException;

import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;

import org.ow2.carol.cmi.reference.CMIProxyHandleImpl;
import org.ow2.carol.cmi.rpc.CMIProxy;

/**
 * Extend the class {@link CMIProxyHandleImpl} in order to implement the interface {@link HomeHandle}.
 * @author Loris Bouzonnet
 */
public class EJBHomeHandle extends CMIProxyHandleImpl implements HomeHandle {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 2880811153354401374L;


    public EJBHomeHandle(final String objectName, final String interfaceName, final EJBHome ejbHomeProxy) {
        super(objectName, interfaceName, (CMIProxy) ejbHomeProxy);
    }

    public EJBHome getEJBHome() throws RemoteException {
        return (EJBHome) getCMIProxy();
    }

}
