/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ejb2_1.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.pool.EJBObjectFactory;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBHomeInvocationHandler;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.spec.EJBObjectHandle;
import org.ow2.carol.cmi.rpc.CMIInvocationHandlerByPool;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class EJBObjectInvocationHandler
extends CMIInvocationHandlerByPool<EJBObject> {
    private static final long serialVersionUID = 7543664459135220878L;
    private static final Log LOGGER = LogFactory.getLog(EJBObjectInvocationHandler.class);
    private transient ClassLoader classLoader;
    private transient Class<? extends EJBHome> homeClass;
    private transient EJBHome ejbHomeProxy;

    public EJBObjectInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass, Class<? extends EJBObject> remoteClass, EJBHome ejbHomeProxy) {
        super(clusterViewManager, objectName, protocolName, false, remoteClass);
        this.classLoader = classLoader;
        this.homeClass = homeClass;
        this.ejbHomeProxy = ejbHomeProxy;
    }

    protected String proxyToString(Object proxy) {
        return "EJBObjectProxy[" + super.proxyToString(proxy) + ", homeClass:" + this.homeClass.getName() + ", ejbHomeProxy:" + this.ejbHomeProxy + "]";
    }

    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws EJBInvocationHandlerException, Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.equals("getEJBHome")) {
                EJBHome eJBHome = this.ejbHomeProxy;
                return eJBHome;
            }
            if (methodName.equals("isIdentical")) {
                EJBObject ejbObject = (EJBObject)args[0];
                Boolean bl = this.homeClass.equals(ejbObject.getEJBHome().getEJBMetaData().getHomeInterfaceClass());
                return bl;
            }
            if (methodName.equals("remove")) {
                Object ejbObject = null;
                return ejbObject;
            }
            Object ejbObject = super.invokeRemoteMethod(proxy, method, args);
            return ejbObject;
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Error when invoking {0}", new Object[]{method, e});
            throw new EJBInvocationHandlerException("Error when invoking " + method, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() throws EJBInvocationHandlerException {
        try {
            ClusterViewManager clusterViewManager = this.clusterViewManager;
            synchronized (clusterViewManager) {
                if (this.clusterViewManager.getPool(this.objectName) == null) {
                    LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBObject", new Object[]{this.objectName});
                    this.clusterViewManager.setPool(this.objectName, (Pool)new JPool((PoolFactory)new EJBObjectFactory(this.clusterViewManager)));
                }
            }
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (this.homeClass == null) {
                this.homeClass = this.clusterViewManager.getInterface(this.objectName);
            }
            if (this.ejbHomeProxy == null) {
                EJBHomeInvocationHandler ejbHomeInvocationHandler = new EJBHomeInvocationHandler(this.classLoader, this.clusterViewManager, this.objectName, this.protocolName, this.homeClass);
                this.ejbHomeProxy = (EJBHome)Proxy.newProxyInstance(this.classLoader, new Class[]{this.homeClass, CMIProxy.class}, (InvocationHandler)((Object)ejbHomeInvocationHandler));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot init the EJBObject proxy", new Object[]{e});
            throw new EJBInvocationHandlerException("Cannot init the EJBObject proxy", e);
        }
    }

    protected EJBObjectHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new EJBObjectHandle(this.objectName, this.itf.getName(), (EJBObject)cmiProxy);
        }
        return (EJBObjectHandle)this.cmiProxyHandle;
    }
}

