/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: carol@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 * --------------------------------------------------------------------------
 * $Id: EJBObjectHandle.java 1547 2007-12-13 21:32:55Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ejb2_1.spec;

import java.rmi.RemoteException;

import javax.ejb.EJBObject;
import javax.ejb.Handle;

import org.ow2.carol.cmi.reference.CMIProxyHandleImpl;
import org.ow2.carol.cmi.rpc.CMIProxy;

/**
 * Extend the class {@link CMIProxyHandleImpl} in order to implement the interface {@link Handle}.
 * @author Loris Bouzonnet
 */
public final class EJBObjectHandle extends CMIProxyHandleImpl implements Handle {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 6590714152068350344L;


    public EJBObjectHandle(final String objectName, final String interfaceName, final EJBObject ejbObjectProxy) {
        super(objectName, interfaceName, (CMIProxy) ejbObjectProxy);
    }

    public EJBObject getEJBObject() throws RemoteException {
        return (EJBObject) getCMIProxy();
    }

}
