/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.ejb2_1.rpc.ha;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.ow2.carol.cmi.controller.common.ClusterViewManager;
import org.ow2.carol.cmi.ejb2_1.rpc.EJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.rpc.ha.CreateMethodWrapper;
import org.ow2.carol.cmi.ejb2_1.rpc.ha.HAEJBHomeInvocationHandler;
import org.ow2.carol.cmi.ejb2_1.rpc.ha.HAEJBInvocationHandlerException;
import org.ow2.carol.cmi.ejb2_1.spec.EJBObjectHandle;
import org.ow2.carol.cmi.ha.RequestId;
import org.ow2.carol.cmi.ha.SessionId;
import org.ow2.carol.cmi.ha.interceptor.HACurrent;
import org.ow2.carol.cmi.pool.StubOrProxyFactory;
import org.ow2.carol.cmi.reference.CMIReference;
import org.ow2.carol.cmi.reference.CMIReferenceable;
import org.ow2.carol.cmi.reference.CMIReferenceableWrapper;
import org.ow2.carol.cmi.rpc.CMIInvocationHandler;
import org.ow2.carol.cmi.rpc.CMIProxy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAEJBObjectInvocationHandler
extends CMIInvocationHandler<EJBObject> {
    private static final long serialVersionUID = -3471150548023542467L;
    private static final Log LOGGER = LogFactory.getLog(HAEJBObjectInvocationHandler.class);
    private transient ClassLoader classLoader;
    private transient Class<? extends EJBHome> homeClass;
    private transient HAEJBHomeInvocationHandler homeInvocationHandler;
    private transient EJBHome ejbHomeProxy;
    private SessionId sessionId;
    private int requestNb = 0;
    private CreateMethodWrapper createMethodWrapper;
    private boolean onFailover = false;

    public HAEJBObjectInvocationHandler(ClassLoader classLoader, ClusterViewManager clusterViewManager, String objectName, String protocolName, Class<? extends EJBHome> homeClass, Class<? extends EJBObject> remoteClass, HAEJBHomeInvocationHandler homeInvocationHandler, EJBHome ejbHomeProxy, SessionId sessionId, CreateMethodWrapper createMethodWrapper, CMIReferenceable<EJBObject> wrappedRemoteStub) {
        super(clusterViewManager, objectName, protocolName, true, remoteClass);
        this.classLoader = classLoader;
        this.homeClass = homeClass;
        this.homeInvocationHandler = homeInvocationHandler;
        this.ejbHomeProxy = ejbHomeProxy;
        this.sessionId = sessionId;
        this.createMethodWrapper = createMethodWrapper;
        this.setCurrentRef(wrappedRemoteStub);
    }

    protected String proxyToString(Object proxy) {
        return "HAEJBObjectProxy[" + super.proxyToString(proxy) + ", homeClass:" + this.homeClass.getName() + ", ejbHomeProxy:" + this.ejbHomeProxy + ", sessionId:" + this.sessionId + ", requestNb:" + this.requestNb + ", createMethodWrapper:" + this.createMethodWrapper + ", onFailover:" + this.onFailover + "]";
    }

    protected Object invokeRemoteMethod(Object proxy, Method method, Object ... args) throws Throwable {
        String methodName = method.getName();
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.setClassLoader(oldClassLoader);
        try {
            if (methodName.equals("getEJBHome")) {
                EJBHome eJBHome = this.ejbHomeProxy;
                return eJBHome;
            }
            if (methodName.equals("isIdentical")) {
                EJBObject ejbObject = (EJBObject)args[0];
                Boolean bl = this.homeClass.equals(ejbObject.getEJBHome().getEJBMetaData().getHomeInterfaceClass());
                return bl;
            }
            RequestId requestId = new RequestId(this.sessionId, this.requestNb);
            HACurrent.getHACurrent().putNextReq(requestId);
            Object result = super.invokeRemoteMethod(proxy, method, args);
            ++this.requestNb;
            if (this.onFailover) {
                this.onFailover = false;
                HACurrent.getHACurrent().setOnFailover(false);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Error when invoking {0}", new Object[]{method, e});
            throw new EJBInvocationHandlerException("Error when invoking " + method, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void onExceptionHook(String objectName, CMIReferenceable<EJBObject> cmiReferenceable) throws Throwable {
        CMIReferenceableWrapper<EJBObject> wrappedRemoteStub;
        try {
            this.clusterViewManager.getPool(objectName).discard(cmiReferenceable);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot discard the reference {0}", new Object[]{cmiReferenceable, e});
        }
        ArrayList argTypes = new ArrayList();
        for (String argTypename : this.createMethodWrapper.getArgTypenames()) {
            argTypes.add(Class.forName(argTypename));
        }
        Method createMethod = this.homeClass.getDeclaredMethod(this.createMethodWrapper.getMethodName(), argTypes.toArray(new Class[argTypes.size()]));
        try {
            wrappedRemoteStub = this.homeInvocationHandler.getWrappedEJBObject(this.ejbHomeProxy, createMethod, this.createMethodWrapper.getArgs());
        }
        catch (Throwable e) {
            if (e instanceof EJBException) {
                throw e;
            }
            LOGGER.error((Object)"Failover: Error when invoking {0}", new Object[]{createMethod, e});
            throw new HAEJBInvocationHandlerException("Failover: Error when invoking " + createMethod, e);
        }
        this.setCurrentRef((CMIReferenceable)wrappedRemoteStub);
        this.onFailover = true;
        HACurrent.getHACurrent().setOnFailover(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitialized() throws HAEJBInvocationHandlerException {
        try {
            ClusterViewManager clusterViewManager = this.clusterViewManager;
            synchronized (clusterViewManager) {
                if (this.clusterViewManager.getPool(this.objectName) == null) {
                    LOGGER.debug((Object)"First lookup on {0}: creation of the pool for its stubs for EJBHome", new Object[]{this.objectName});
                    JPool pool = new JPool((PoolFactory)new StubOrProxyFactory(this.clusterViewManager));
                    pool.setPoolConfiguration(this.clusterViewManager.getPoolConfiguration(this.objectName));
                    this.clusterViewManager.setPool(this.objectName, (Pool)pool);
                }
            }
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (this.homeClass == null) {
                this.homeClass = this.clusterViewManager.getInterface(this.objectName);
            }
            if (this.homeInvocationHandler == null || this.ejbHomeProxy == null) {
                this.homeInvocationHandler = new HAEJBHomeInvocationHandler(this.classLoader, this.clusterViewManager, this.objectName, this.protocolName, this.homeClass);
                this.ejbHomeProxy = (EJBHome)Proxy.newProxyInstance(this.classLoader, new Class[]{this.homeClass, CMIProxy.class}, (InvocationHandler)((Object)this.homeInvocationHandler));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot init the HA EJBObject proxy", new Object[]{e});
            throw new HAEJBInvocationHandlerException("Cannot init the HA EJBObject proxy", e);
        }
    }

    protected EJBObjectHandle getHandle(CMIProxy cmiProxy) {
        if (this.cmiProxyHandle == null) {
            this.cmiProxyHandle = new EJBObjectHandle(this.objectName, this.itf.getName(), (EJBObject)cmiProxy);
        }
        return (EJBObjectHandle)this.cmiProxyHandle;
    }

    protected CMIReferenceable<EJBObject> getCMIReferenceable(CMIReference cmiReference) throws Exception {
        return null;
    }

    protected void onFinallyHook(String objectName, CMIReferenceable<EJBObject> cmiReferenceable) {
        try {
            this.clusterViewManager.getPool(objectName).release(cmiReferenceable);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot release the reference {0}", new Object[]{cmiReferenceable, e});
        }
    }
}

