/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2002-2007 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:TestClient.java 949 2007-06-02 17:24:33Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;


import org.ow2.carol.cmi.admin.CMIAdmin;
import org.ow2.carol.cmi.config.JNDIConfig;

/**
 * @author nieuviar
 * @author The new CMI team
 *
 */
public final class TestClient {

    private static Context ic = null;

    private static CMIAdmin cmiAdmin = null;

    protected static HashMap<String, TestItf> testItfs = new HashMap<String, TestItf>();

    /**
     * Private default constructor as a result of being a utility class.
     */
    private TestClient() {
    }


    protected static class LookupHandler implements Console.TokenHandlerITF {
        private String args[];

        public LookupHandler() {
        }

        public LookupHandler(String args[]) {
            this.args = args;
        }

        public void setArgs(String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Lookup \"" + args[1] + "\"...");
                TestItf testItf = (TestItf) ic.lookup(args[1]);
                try {
                    testItf.display();
                } catch (RemoteException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                testItfs.put(args[1], testItf);
            } catch (NamingException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DispCacheHandler implements Console.TokenHandlerITF {
        private String args[];

        public DispCacheHandler() {
        }

        public DispCacheHandler(String args[]) {
            this.args = args;
        }

        public void setArgs(String args[]) {
            this.args = args;
        }

        public int handle() {
            System.out.println("Contain of the cache:");
            for(String s : testItfs.keySet()) {
                System.out.println("  * "+s);
            }
            return 0;
        }
    }

    protected static class InvokeHandler implements Console.TokenHandlerITF {
        private String args[];

        public InvokeHandler() {
        }

        public InvokeHandler(String args[]) {
            this.args = args;
        }

        public void setArgs(String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Invoke \"" + args[1] + "\"...");
                testItfs.get(args[1]).display();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DispInfosHandler implements Console.TokenHandlerITF {
        private String args[];

        public DispInfosHandler() {
        }

        public DispInfosHandler(String args[]) {
            this.args = args;
        }

        public void setArgs(String args[]) {
            this.args = args;
        }

        public int handle() {

            List<String> jndiRefs;
            try {
                jndiRefs = cmiAdmin.getServerRefs(args[1], "jrmp");
                System.out.println("/************************/");
                System.out.println("/*     Cluster view     */");
                System.out.println("/* Node list:           */");
                if(jndiRefs != null) {
                    for(String jndiRef : jndiRefs) {
                        System.out.println("/*   "+jndiRef+"  */");

                    }
                }
                System.out.println("/* LB policy:           */");
                System.out.println("/*   "+cmiAdmin.getLBPolicyClassName(args[1])+"  */");
//              System.out.println("/* Strategy:            */");
//              System.out.println("/*   "+cmiAdmin.getStrategyName(args[1])+"  */");
                System.out.println("/************************/");
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }


            return 0;
        }
    }

//    protected static class RefreshHandler implements Console.TokenHandlerITF {
//
//        public int handle() {
//            try {
//                cmiAdmin.doRefresh();
//            } catch (CMIAdminException e) {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
//            return 0;
//        }
//
//        public void setArgs(String[] args) {
//            // TODO Auto-generated method stub
//
//        }
//
//    }

    public static void main(final String[] args) throws Exception {

        if(args[0] == null) {
            System.out.println("You must specify the filename for configuring CMIContext.");
            return;
        }

        FileOutputStream fos = new FileOutputStream("output/reports/client_errors.txt");
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);

        Hashtable<String, ?> env =
            JNDIConfig.getCMIEnv(Thread.currentThread().getContextClassLoader().getResource(args[0]));

        // Get InitialContext
        try {
            ic = new InitialContext(env);
            ((TestItf) ic.lookup("toto")).display();
            cmiAdmin = CMIAdmin.getCMIAdmin();
            Console cons = new Console("client");
            cons.addToken("dispcache", 0, new DispCacheHandler(), "displays the cache");
            cons.addToken("lookup", 1, new LookupHandler(), "lookup with the name [arg]");
            cons.addToken("invoke", 1, new InvokeHandler(), "invoke with the name [arg]");
            cons.addToken("dispInfos", 1, new DispInfosHandler(), "display infos for the name [arg]");
//            cons.addToken("refresh", 0, new RefreshHandler(), "refresh the cluster view");
            cons.start();

        } catch (NamingException e) {
            e.printStackTrace();
        }

    }
}
