/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.cmi.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.carol.cmi.admin.CMIAdmin;
import org.ow2.carol.cmi.config.JNDIConfig;
import org.ow2.carol.cmi.test.Console;
import org.ow2.carol.cmi.test.TestItf;

public final class TestClient {
    private static Context ic = null;
    private static CMIAdmin cmiAdmin = null;
    protected static HashMap<String, TestItf> testItfs = new HashMap();

    private TestClient() {
    }

    public static void main(String[] args) throws Exception {
        if (args[0] == null) {
            System.out.println("You must specify the filename for configuring CMIContext.");
            return;
        }
        FileOutputStream fos = new FileOutputStream("output/reports/client_errors.txt");
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);
        Hashtable env = JNDIConfig.getCMIEnv((URL)Thread.currentThread().getContextClassLoader().getResource(args[0]));
        try {
            ic = new InitialContext(env);
            ((TestItf)ic.lookup("toto")).display();
            cmiAdmin = CMIAdmin.getCMIAdmin();
            Console cons = new Console("client");
            cons.addToken("dispcache", 0, new DispCacheHandler(), "displays the cache");
            cons.addToken("lookup", 1, new LookupHandler(), "lookup with the name [arg]");
            cons.addToken("invoke", 1, new InvokeHandler(), "invoke with the name [arg]");
            cons.addToken("dispInfos", 1, new DispInfosHandler(), "display infos for the name [arg]");
            cons.start();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    protected static class DispInfosHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public DispInfosHandler() {
        }

        public DispInfosHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                List jndiRefs = cmiAdmin.getServerRefs(this.args[1], "jrmp");
                System.out.println("/************************/");
                System.out.println("/*     Cluster view     */");
                System.out.println("/* Node list:           */");
                if (jndiRefs != null) {
                    for (String jndiRef : jndiRefs) {
                        System.out.println("/*   " + jndiRef + "  */");
                    }
                }
                System.out.println("/* LB policy:           */");
                System.out.println("/*   " + cmiAdmin.getLBPolicyClassName(this.args[1]) + "  */");
                System.out.println("/************************/");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class InvokeHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public InvokeHandler() {
        }

        public InvokeHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Invoke \"" + this.args[1] + "\"...");
                testItfs.get(this.args[1]).display();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DispCacheHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public DispCacheHandler() {
        }

        public DispCacheHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            System.out.println("Contain of the cache:");
            for (String s : testItfs.keySet()) {
                System.out.println("  * " + s);
            }
            return 0;
        }
    }

    protected static class LookupHandler
    implements Console.TokenHandlerITF {
        private String[] args;

        public LookupHandler() {
        }

        public LookupHandler(String[] args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Lookup \"" + this.args[1] + "\"...");
                TestItf testItf = (TestItf)ic.lookup(this.args[1]);
                try {
                    testItf.display();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                testItfs.put(this.args[1], testItf);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}

