/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007,2008 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JRMPHelloServer.java 1649 2008-02-28 17:36:13Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.test;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.ow2.carol.cmi.admin.CMIAdmin;
import org.ow2.carol.cmi.annotation.Cluster;
import org.ow2.carol.cmi.annotation.Policy;
import org.ow2.carol.cmi.config.JNDIConfig;
import org.ow2.carol.cmi.info.CMIInfoExtractor;
import org.ow2.carol.cmi.info.CMIInfoExtractorException;
import org.ow2.carol.cmi.info.ClusteredObjectInfo;
import org.ow2.carol.cmi.jndi.ClusteredObject;
import org.ow2.carol.cmi.lb.policy.HASingletonPolicy;
import org.ow2.carol.cmi.lb.policy.RoundRobinPolicy;
import org.ow2.carol.cmi.reference.ObjectNotFoundException;
import org.ow2.carol.cmi.smart.server.SmartEndPoint;

/**
 * @author nieuviar
 * @author The new CMI team
 *
 */
@Cluster(name="test_cluster")
@Policy(RoundRobinPolicy.class)
public class JRMPHelloServer extends PortableRemoteObject implements TestItf, ClusteredObject {

    private static ClusteredObjectInfo clusteredObjectInfo;

    private static CMIAdmin cmiAdmin = null;

    private static Context ic;

    private String msg;

    protected static HashMap<String, TestItf> testItfs = new HashMap<String, TestItf>();

    protected static class LookupHandler implements Console.TokenHandlerITF {
        private String args[];

        public LookupHandler() {
        }

        public LookupHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Lookup \"" + args[1] + "\"...");
                TestItf testItf = (TestItf) ic.lookup(args[1]);
                testItfs.put(args[1], testItf);
            } catch (NamingException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class InvokeHandler implements Console.TokenHandlerITF {
        private String args[];

        public InvokeHandler() {
        }

        public InvokeHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Invoke \"" + args[1] + "\"...");
                testItfs.get(args[1]).display();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class DisplayRegistryHandler implements Console.TokenHandlerITF {

        private String args[];

        public DisplayRegistryHandler() {
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
//            try {
//                cmiAdmin.setLBPolicyClassName("toto", HASingletonPolicy.class.getName());
//                List<String> serverRefs = new ArrayList<String>();
//                serverRefs.add(0, "rmi://129.183.101.165:1098");
//                serverRefs.add(1, "rmi://129.183.101.165:1099");
//                cmiAdmin.setListPropertyForLBPolicy("toto", "serverRefs", serverRefs);
//                Thread.sleep(1000);
//            } catch (Exception e) {
//                // TODO Auto-generated catch block
//                e.printStackTrace();
//            }
            displayRegistry(ic);
            return 0;
        }
    }

    protected static class DisplayReplicatedRegistryHandler implements Console.TokenHandlerITF {

        private String args[];

        public DisplayReplicatedRegistryHandler() {
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            System.out.println();
            System.out.println("/*************************/");
            System.out.println("/* REPLICATED REGISTRY:");
            try {
                Set<String> clusterNames = cmiAdmin.getClusterNames();
                for(String clusterName : clusterNames) {
                    System.out.println();
                    System.out.println("/* In the cluster "+clusterName+":");
                    Set<String> objectNames = cmiAdmin.getObjectNames(clusterName);
                    for(String objectName : objectNames) {
                        System.out.println("/*   "+objectName+" has:");
                        System.out.println("/*  - instance(s) in the following nodes:");
                        List<String> jndiRefs = cmiAdmin.getServerRefs(objectName);
                        for(String jndiRef : jndiRefs) {
                            System.out.println("/*     >"+jndiRef);
                        }
                        System.out.println("/*  - for LB policy:");
                        System.out.println("/*     >"+cmiAdmin.getLBPolicyClassName(objectName));
                        System.out.println("/*  - for LB strategy:");
                        System.out.println("/*     >"+cmiAdmin.getLBStrategyClassName(objectName));
                    }
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            System.out.println("/*************************/");
            System.out.println();
            return 0;
        }
    }

//    public JRMPHelloServer(final String string) throws RemoteException {
//        msg = string;
////		URL url = Thread.currentThread().getContextClassLoader().getResource("examples-dd.xml");
//        try {
//            clusteredObjectInfo =
////				CMIInfoExtractor.extractClusteringInfoFromDD(TestItf.class.getName(), url);
//                CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(TestItf.class.getName(), JRMPHelloServer.class);
//        } catch (CMIInfoExtractorException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//    }

    public JRMPHelloServer(final String string) throws RemoteException {
        msg = string;
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(
                    "jrmpHelloServer", TestItf.class, JRMPHelloServer.class,
                    false, false, null);
        } catch (CMIInfoExtractorException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    private static void displayRegistry(final Context ctx) {
        System.out.println();
        System.out.println("/********************/");
        System.out.println("/* REGISTRY:");
        try {
            NamingEnumeration<NameClassPair> list = ctx.list(ctx.getNameInNamespace());

            while (list.hasMore()) {
                NameClassPair current = list.next();
                String name = current.getName();
                System.out.println("/*    - " + name);
                System.out.println("/*  Servers which own an instance of this:");
                List<String> jndiRefs = cmiAdmin.getServerRefs(name, "jrmp");
                for(String jndiRef:jndiRefs) {
                    System.out.println("/*  > "+jndiRef.toString());
                }
            }

            System.out.println("/********************/");
            System.out.println();

        } catch (NamingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

    }

    protected static class BindHandler implements Console.TokenHandlerITF {
        private String args[];

        public BindHandler() {
        }

        public BindHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Binding \"" + args[1] + "\"...");
                JRMPHelloServer s = new JRMPHelloServer(args[1]);
                ic.bind(args[1], s);
                System.out.println("OK");
            } catch (NamingException e) {
                e.printStackTrace();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class RebindHandler implements Console.TokenHandlerITF {
        private String args[];

        public RebindHandler() {
        }

        public RebindHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Rebinding \"" + args[1] + "\"...");
                JRMPHelloServer s = new JRMPHelloServer(args[1]);
                ic.rebind(args[1], s);
                System.out.println("OK");
            } catch (NamingException e) {
                e.printStackTrace();
            } catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class UnbindHandler implements Console.TokenHandlerITF {
        private String args[];

        public UnbindHandler() {
        }

        public UnbindHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {
            try {
                System.out.print("Unbinding \"" + args[1] + "\"...");
                ic.unbind(args[1]);
                System.out.println("OK");
            } catch (NamingException e) {
                // TODO Auto-generated catch block
                System.out.print("Naming exception");
                e.printStackTrace();
                return 1;
            }
            return 0;
        }
    }

    protected static class DispInfosHandler implements Console.TokenHandlerITF {
        private String args[];

        public DispInfosHandler() {
        }

        public DispInfosHandler(final String args[]) {
            this.args = args;
        }

        public void setArgs(final String args[]) {
            this.args = args;
        }

        public int handle() {

            List<String> jndiRefs;
            try {
                jndiRefs = cmiAdmin.getServerRefs(args[1], "jrmp");
                System.out.println("/************************/");
                System.out.println("/*     Cluster view     */");
                System.out.println("/* Node list:           */");
                if(jndiRefs != null) {
                    for(String jndiRef : jndiRefs) {
                        System.out.println("/*   "+jndiRef+"  */");

                    }
                }
                System.out.println("/* LB policy:           */");
                System.out.println("/*   "+cmiAdmin.getLBPolicyClassName(args[1])+"  */");
//				System.out.println("/* Strategy:            */");
//				System.out.println("/*   "+cmiAdmin.getStrategyName(args[1])+"  */");
                System.out.println("/************************/");
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }


            return 0;
        }
    }

    public static void main(final String[] args) throws Exception {

        FileOutputStream fos = new FileOutputStream("output/reports/errors-jrmp.txt");
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);

        URL url = Thread.currentThread().getContextClassLoader().getResource("server-jrmp.properties");

        Hashtable<String, ?> env = JNDIConfig.getCMIEnv(url);
        ic = new InitialContext(env);

        cmiAdmin = CMIAdmin.getCMIAdmin();

//		SmartEndPoint sep = new SmartEndPoint();
//		sep.start();

        Console cons = new Console("server");

        cons.addToken("dispreg", 0, new DisplayRegistryHandler(), "displays the registry");

        cons.addToken("lookup", 1, new LookupHandler(), "lookup with the name [arg]");
        cons.addToken("invoke", 1, new InvokeHandler(), "invoke with the name [arg]");

        cons.addToken("bind", 1, new BindHandler(), "bind with the name [arg]");

        cons.addToken("rebind", 1, new RebindHandler(), "rebind with the name [arg]");

        cons.addToken("unbind", 1, new UnbindHandler(), "unbind the name [arg]");

        cons.addToken("disprep", 0, new DisplayReplicatedRegistryHandler(), "displays the replicated registry");
        cons.addToken("dispInfos", 1, new DispInfosHandler(), "display infos for the name [arg]");

        cons.start();
    }

    /**
     * Displays "hello".
     * @throws RemoteException if a {@link RemoteException} occurs.
     **/
    public void display() throws RemoteException {
        System.out.println("Hello "+msg);
    }

    public ClusteredObjectInfo getClusteredObjectInfo() {
        return clusteredObjectInfo;
    }
}
