/**
 * High Availability Service (HA) for JOnAS
 *
 * Copyright (C) 2006 Distributed Systems Lab.
 * Universidad Politecnica de Madrid (Spain)
 * Contact: http://lsd.ls.fi.upm.es/lsd
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HACurrent.java 1469 2007-11-03 16:38:31Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ha.interceptor;

import java.util.Stack;

import org.ow2.carol.cmi.ha.RequestId;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Class enabling to get the current context.
 */
public class HACurrent {

    /**
     * Logger used.
     */
    private Log logger = LogFactory.getLog(HACurrent.class);

    /**
     * Singleton.
     */
    private static HACurrent singleton = null;

    /**
     * @return Get the singleton
     */
    public static HACurrent getHACurrent() {

        if (singleton == null) {
            singleton = new HACurrent();
        }
        return singleton;
    }

    /**
     * Local thread
     */
    private static InheritableThreadLocal<HAContext> threadCtx =
        new InheritableThreadLocal<HAContext>();

    /**
     * Set the requests stack in the current context
     * @param requests the next request
     */
    public void setRequests(final Stack<RequestId> requests) {
        HAContext current = getCurrentContext();
        current.setRequests(requests);
        threadCtx.set(current);
    }
    /**
     * Get the request stack
     * @return the request stack
     */
    public Stack<RequestId> getRequests() {
        return getCurrentContext().getRequests();
    }

    /**
     * Put the request in the request stack
     * @param nextReq the next request
     */
    public void putNextReq(final RequestId nextReq) {
        HAContext current = getCurrentContext();
        current.putNextReq(nextReq);
        threadCtx.set(current);
    }

    /**
     * Sets the onFailover variable
     * @param onFailover
     */
    public void setOnFailover(final boolean onFailover) {
        HAContext current = getCurrentContext();
        current.setOnFailover(onFailover);
        threadCtx.set(current);
    }

    /**
     * Gets the onFailover variable
     * @return true if on failover
     */
    public boolean isOnFailover() {
        return getCurrentContext().isOnFailover();

    }

    private HAContext getCurrentContext() {
        HAContext current = threadCtx.get();
        if (current == null) {
            current = new HAContext();
        }
        return current;
    }

}
