/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: BeanInfo.java 1477 2007-11-09 13:33:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

import java.io.Serializable;


/**
 * This class holds the required information to replicate the beans' state.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class BeanInfo implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -6471141185394014855L;

    /**
     * The ObjectId of the bean as unique identifier for beanChanges table.
     */
    private SessionId bId;

    /**
     * The bean state as an array of bytes.
     */
    private byte[] state;

    /**
     * The bean reference.
     */
    private transient StatefulBeanReference bean;


    /**
     * Constructor.
     * @param bid
     * @param state
     */
    public BeanInfo(final SessionId bid, final StatefulBeanReference bean) {
        this.bId = bid;
        this.bean = bean;
        this.state = null;
    }

    /**
     * @return Returns the bId.
     */
    public SessionId getBId() {
        return bId;
    }

    /**
     * @param id The bId to set.
     */
    public void setBId(final SessionId id) {
        bId = id;
    }

    /**
     * @return Returns the state.
     */
    public byte[] getState() {
        return state;
    }

    /**
     * @param state The state to set.
     */
    public void setState(final byte[] state) {
        this.state = state;
    }

    /**
     * Returns the bean.
     * @return the bean
     */
    public StatefulBeanReference getBean() {
        return this.bean;
    }

    /**
     * Obtains the state from the bean and store it in state.
     * @throws ReplicationException
     */
    public void obtainBeanState() throws ReplicationException {
        if (bean != null) {
            state = bean.getState();
        }
    }

    @Override
    public String toString() {
        return "BId: " + bId;
    }
}
