/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: ReplicationException.java 1293 2007-10-07 09:52:15Z loris $
* --------------------------------------------------------------------------
*/

package org.ow2.carol.cmi.ha;

/**
 * Thrown when a replication error is detected.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class ReplicationException extends Exception {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 2581708522071671110L;

    public ReplicationException() {
        super();
    }

    public ReplicationException(final String message) {
        super(message);
    }

    public ReplicationException(final String message, final Throwable cause) {
        super(message, cause);
    }

    public ReplicationException(final Throwable cause) {
        super(cause);
    }

}
