/**
* High Availability Service (HA) for JOnAS
*
* Copyright (C) 2006 Distributed Systems Lab.
* Universidad Polit??cnica de Madrid (Spain)
* Contact: http://lsd.ls.fi.upm.es/lsd
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: StatefulBeanReference.java 1477 2007-11-09 13:33:15Z loris $
* --------------------------------------------------------------------------
*/
package org.ow2.carol.cmi.ha;


/**
 * This interface implements reference to stateful beans.
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public interface StatefulBeanReference {

    /**
     * Gets the state of the associated bean.
     * @return The state
     * @throws ReplicationException
     */
    byte[] getState() throws ReplicationException;

    /**
     * Returns true if the bean is modified.
     * @return true if the bean is modified
     * @throws ReplicationException
     */
    boolean isModified() throws ReplicationException;

    /**
     * Inject the state in the bean.
     * @throws ReplicationException
     */
    void injectState(byte[] state) throws ReplicationException;
}
