/**
 * High Availability Service (HA) for JOnAS
 *
 * Copyright (C) 2006 Distributed Systems Lab.
 * Universidad Polit??cnica de Madrid (Spain)
 * Contact: http://lsd.ls.fi.upm.es/lsd
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HAContext.java 1469 2007-11-03 16:38:31Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.carol.cmi.ha.interceptor;

import java.io.Serializable;
import java.util.Stack;

import org.ow2.carol.cmi.ha.RequestId;

/**
 * This is the class stored in the Thread local variable of HACurrent class and
 * represents the thread associated HA context
 * @author Francisco Perez-Sorrosal (fpsorrosal@no-spam@fi.upm.es)
 * @author Alberto Paz-Jimenez (apaz@no-spam@fi.upm.es)
 */
public class HAContext implements Serializable {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = 8622240885538001300L;

    /**
     * Holds info about the request chain
     */
    private Stack<RequestId> requests = new Stack<RequestId>();

    /**
     * Holds the on failover info
     */
    private boolean onFailover = false;

    /**
     * Constructor
     */
    public HAContext() {
    }

    /**
     * Set the requests
     * @param reqs the requests
     */
    public void setRequests(final Stack<RequestId> reqs) {
        requests = reqs;
    }

    /**
     * Get the requests
     * @return the requests
     */
    public Stack<RequestId> getRequests() {
        return requests;
    }

    /**
     * Put the request as the last request
     */
    public void putNextReq(final RequestId nextReq) {
        // Check that the request is not in the Stack
        if (requests.contains(nextReq)) {
            while (!requests.peek().equals(nextReq)) {
                requests.pop();
            }
        } else {
            requests.push(nextReq);
        }
    }

    /**
     * @return Returns the onFailover.
     */
    public boolean isOnFailover() {
        return onFailover;
    }

    /**
     * @param onFailover The onFailover to set.
     */
    public void setOnFailover(final boolean onFailover) {
        this.onFailover = onFailover;
    }

}
